/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.snowyspirit.common.wreath;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.mehvahdjukaar.snowyspirit.reg.ModRegistry;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_18;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2750;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_7225;

public class WreathSavedData
extends class_18 {
    private static final String FILE_ID = "wreaths";
    public static final class_18.class_8645<WreathSavedData> FACTORY = new class_18.class_8645(WreathSavedData::new, (compoundTag, registries) -> {
        WreathSavedData data = new WreathSavedData();
        data.load((class_2487)compoundTag, (class_7225.class_7874)registries);
        return data;
    }, null);
    private static final WreathSavedData clientData = new WreathSavedData();
    private final Map<class_2338, Data> wreathBlocks = new HashMap<class_2338, Data>();

    public static WreathSavedData get(class_1937 level) {
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            return (WreathSavedData)serverLevel.method_17983().method_17924(FACTORY, FILE_ID);
        }
        return clientData;
    }

    public class_2487 method_75(class_2487 tag, class_7225.class_7874 registries) {
        int i = 0;
        for (class_2338 pos : this.wreathBlocks.keySet()) {
            class_2512.method_10692((class_2338)pos);
            tag.method_10566("" + i, class_2512.method_10692((class_2338)pos));
            ++i;
        }
        tag.method_10569("Count", i);
        return tag;
    }

    public void load(class_2487 total, class_7225.class_7874 reg) {
        for (int i = 0; i < total.method_10550("Count"); ++i) {
            class_2338 pos = (class_2338)class_2512.method_10691((class_2487)total, (String)("" + i)).orElseThrow();
            this.addWreath(pos);
        }
    }

    public Data addWreath(class_2338 pos) {
        return this.wreathBlocks.computeIfAbsent(pos, Data::new);
    }

    public void removeWreath(class_2338 p, class_1937 level, boolean animationAndDrop) {
        this.wreathBlocks.remove(p);
        if (animationAndDrop) {
            class_1542 itementity = new class_1542(level, (double)p.method_10263() + 0.5, (double)p.method_10264() + 0.5, (double)p.method_10260() + 0.5, ModRegistry.WREATH.get().method_8389().method_7854());
            itementity.method_6988();
            level.method_8649((class_1297)itementity);
            level.method_20290(2001, p, class_2248.method_9507((class_2680)ModRegistry.WREATH.get().method_9564()));
        }
    }

    public Map<class_2338, Data> getWreathBlocks() {
        return this.wreathBlocks;
    }

    public boolean hasWreath(class_2338 pos) {
        return this.wreathBlocks.containsKey(pos);
    }

    public void refreshWreathVisual(class_2338 pos, class_1937 level) {
        if (level.method_8477(pos)) {
            class_2680 state = level.method_8320(pos);
            if (state.method_26204() instanceof class_2323) {
                class_2350 dir = (class_2350)state.method_11654((class_2769)class_2323.field_10938);
                boolean open = (Boolean)state.method_11654((class_2769)class_2323.field_10945);
                boolean hinge = state.method_11654((class_2769)class_2323.field_10941) == class_2750.field_12586;
                Data data = this.addWreath(pos);
                data.face = dir;
                data.hinge = hinge;
                data.open = open;
                if (data.needsInitialization) {
                    this.calculateDoorDimensions(level, pos, state, data);
                    data.needsInitialization = false;
                }
            } else {
                this.removeWreath(pos, level, false);
            }
        }
    }

    private void calculateDoorDimensions(class_1937 level, class_2338 pos, class_2680 state, Data data) {
        double back;
        double front;
        state = (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2323.field_10938, (Comparable)class_2350.field_11043)).method_11657((class_2769)class_2323.field_10945, (Comparable)Boolean.FALSE)).method_11657((class_2769)class_2323.field_10941, (Comparable)class_2750.field_12586);
        class_265 shape = state.method_26218((class_1922)level, pos);
        class_238 bounds = shape.method_1107();
        if (bounds.field_1320 - bounds.field_1323 >= 1.0) {
            front = bounds.field_1321 - 1.0;
            back = -bounds.field_1324;
            data.closedDimensions = Pair.of((Object)Float.valueOf((float)front), (Object)Float.valueOf((float)back));
        }
        state = (class_2680)((class_2680)state.method_11657((class_2769)class_2323.field_10945, (Comparable)Boolean.TRUE)).method_11657((class_2769)class_2323.field_10938, (Comparable)class_2350.field_11034);
        shape = state.method_26218((class_1922)level, pos);
        bounds = shape.method_1107();
        if (bounds.field_1320 - bounds.field_1323 >= 1.0) {
            front = bounds.field_1321 - 1.0;
            back = -bounds.field_1324;
            data.openDimensions = Pair.of((Object)Float.valueOf((float)front), (Object)Float.valueOf((float)back));
        }
    }

    public void refreshClientBlocksVisuals(class_1937 level) {
        HashSet<class_2338> positions = new HashSet<class_2338>(this.wreathBlocks.keySet());
        positions.forEach(p -> this.refreshWreathVisual((class_2338)p, level));
    }

    public void updateAllBlocks(class_3218 level) {
        HashSet<class_2338> positions = new HashSet<class_2338>(this.wreathBlocks.keySet());
        positions.forEach(p -> {
            class_2680 state;
            if (level.method_8477(p) && !((state = level.method_8320(p)).method_26204() instanceof class_2323)) {
                this.removeWreath((class_2338)p, (class_1937)level, true);
            }
        });
    }

    public static class Data {
        private class_2350 face = class_2350.field_11043;
        private boolean open = true;
        private boolean hinge = true;
        private boolean needsInitialization = true;
        private Pair<Float, Float> openDimensions = null;
        private Pair<Float, Float> closedDimensions = null;

        public Data(class_2338 pos) {
        }

        public class_2350 getDirection() {
            if (this.open) {
                return this.hinge ? this.face.method_10160() : this.face.method_10170();
            }
            return this.face;
        }

        public boolean isOpen() {
            return this.open;
        }

        public boolean isHinge() {
            return this.hinge;
        }

        public Pair<Float, Float> getDimensions() {
            return this.open ? this.openDimensions : this.closedDimensions;
        }
    }
}

