/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.blocks;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.blocks.IPollutant;
import com.endertech.minecraft.forge.blocks.ISmokeContainer;
import com.endertech.minecraft.forge.configs.BlockStateList;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.configs.MultiConfigProperty;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.IPostInit;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.world.BiomeId;
import com.endertech.minecraft.forge.world.ChunkBounds;
import com.endertech.minecraft.forge.world.DimensionId;
import com.endertech.minecraft.forge.world.Dimensions;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.config.FilterMaterialList;
import com.endertech.minecraft.mods.adpother.entities.AbstractCarrier;
import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import com.endertech.minecraft.mods.adpother.impacts.AbstractPollutionImpacts;
import com.endertech.minecraft.mods.adpother.impacts.EnvironmentalImpacts;
import com.endertech.minecraft.mods.adpother.pollution.IFilterFrame;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import com.endertech.minecraft.mods.adpother.pollution.PollutionInfo;
import com.endertech.minecraft.mods.adpother.pollution.Spread;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.redstone.Orientation;

public abstract class Pollutant<E extends AbstractCarrier>
extends ForgeBlock
implements IPollutant,
IPostInit {
    public static final EnumProperty<Density> DENSITY = EnumProperty.create((String)"density", Density.class);
    public static final int MAX_REACH_DISTANCE = 256;
    protected static final int MIN_HORIZ_SPREAD_DENSITY_DELTA = 2;
    private final List<MultiConfigProperty.BaseProperty<BiomeId, ?>> biomeProperties = new ArrayList();
    protected final Class<E> entityClass;
    protected final FilterMaterialList filterMaterials;
    private final MultiConfigProperty.IntProperty<BiomeId> criticalAmount;
    private final MultiConfigProperty.IntProperty<BiomeId> concentrationAltitude;
    private final MultiConfigProperty.FloatProperty<BiomeId> motionVelocity;
    private final MultiConfigProperty.FloatProperty<BiomeId> emissionRate;
    private final boolean canSpreadAround = true;
    private final boolean canSpreadOverLedge = true;
    private final String name;
    private final ColorARGB color;
    private final ChatFormatting textColor;
    private final CommonCollect.BlackWhiteList<DimensionId> dimensions;
    protected final BlockStateList passableBlocks;

    public Pollutant(UnitConfig config, Properties<?> props, Class<E> entityClass) {
        super(config, props);
        this.entityClass = entityClass;
        this.name = props.name;
        String category = props.name;
        this.filterMaterials = new FilterMaterialList(config, category);
        this.criticalAmount = MultiConfigProperty.IntProperty.from((UnitConfig)config, (String)category, (String)"criticalAmount", (int)props.criticalAmount, (IntBounds)GameBounds.POLLUTION.getIntBounds(), (String)"The amount of pollution at which all negative effects will be maximized.");
        this.concentrationAltitude = MultiConfigProperty.IntProperty.from((UnitConfig)config, (String)category, (String)"concentrationAltitude", (int)props.concentrationAltitude, (IntBounds)IntBounds.INTEGER, (String)"The height that pollutant blocks will try to reach and build up at.\nIf set to a value beyond the building height limit [-64, 319], pollution will not build up and will eventually disappear.");
        this.motionVelocity = MultiConfigProperty.FloatProperty.from((UnitConfig)config, (String)category, (String)"motionVelocity", (float)props.motionVelocity, (FloatBounds)GameBounds.FACTOR.getFloatBounds(), (String)"Motion velocity of the pollutant.");
        this.emissionRate = MultiConfigProperty.FloatProperty.from((UnitConfig)config, (String)category, (String)"emissionRate", (float)1.0f, (FloatBounds)GameBounds.FACTOR.getFloatBounds(), (String)"Emission rate for this pollutant.");
        this.addBiomeIdProperties(new MultiConfigProperty.BaseProperty[]{this.criticalAmount, this.concentrationAltitude, this.motionVelocity, this.emissionRate});
        ColorARGB colorARGB = ColorARGB.from((int)props.mapColor.col).maxOpaque();
        this.color = UnitConfig.getColorARGB((UnitConfig)config, (String)category, (String)"color", (ColorARGB)colorARGB, (String)"Defines a color in ARGB (Alpha, Red, Green, Blue) hex format (0xaarrggbb)\n Affects smog and sky colors.");
        this.textColor = Optional.ofNullable(ChatFormatting.getByName((String)UnitConfig.getStr((UnitConfig)config, (String)category, (String)"textColor", (String)props.textColor.getName(), (String)"Defines the text color for the name of this pollutant."))).orElse(ChatFormatting.WHITE);
        List black = Dimensions.readFrom((UnitConfig)config, (String)category, (String)"dimensionBlackList", (String)"Defines a list of dimensions in which this pollutant will not be generated.", (String[])new String[0]);
        List white = Dimensions.readFrom((UnitConfig)config, (String)category, (String)"dimensionWhiteList", (String)"If this list is set, the pollutant will be generated ONLY in listed dimensions, others will be ignored.", (String[])new String[0]);
        this.dimensions = new CommonCollect.BlackWhiteList(black, white);
        this.passableBlocks = new BlockStateList(config, category, "passableBlocks", new String[]{"#minecraft:carpets", "#minecraft:trapdoors", "minecraft:mangrove_roots:*"}, "List of blocks which this pollutant can pass through.");
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(DENSITY, (Comparable)((Object)Density.LIGHT)));
    }

    public void onPostInit() {
        this.passableBlocks.loadData();
        this.filterMaterials.loadData();
        this.saveConfig();
    }

    public boolean inAllowableDimension(ServerLevel level) {
        return this.dimensions.isEmpty() || this.dimensions.isAllowed((Object)DimensionId.from((Level)level));
    }

    public String getSimpleName() {
        return this.name;
    }

    public Optional<Direction> getMotionFacing(LevelAccessor level, BlockPos pos) {
        return this.getMotionFacing(level, pos, BiomeId.from((LevelAccessor)level, (BlockPos)pos));
    }

    public Optional<Direction> getMotionFacing(LevelAccessor level, BlockPos pos, BiomeId biome) {
        int altitude = this.getConcentrationAltitudeIn(biome);
        if (pos.getY() == altitude) {
            return Optional.empty();
        }
        return Optional.of(pos.getY() < altitude ? Direction.UP : Direction.DOWN);
    }

    public boolean push(LevelAccessor level, BlockPos pos, Direction facing) {
        BlockPos destination = pos.relative(facing);
        if (GameWorld.isBlockLoaded((LevelReader)level, (BlockPos)destination) && this.canStateBeSpreaded(level.getBlockState(pos))) {
            return this.pump(level, destination) && this.spend(level, pos);
        }
        return false;
    }

    public boolean pump(LevelAccessor level, BlockPos pos) {
        return this.pump(level, pos, 1) == 1;
    }

    public int pump(LevelAccessor level, BlockPos pos, int amount) {
        int count;
        BlockState state = level.getBlockState(pos);
        for (count = 0; count < amount && this.canStateBePumped(state); ++count) {
            state = this.getPumpedState(state);
        }
        if (count > 0) {
            level.setBlock(pos, state, 3);
        }
        return count;
    }

    public int spend(LevelAccessor level, BlockPos pos, int amount) {
        int count;
        BlockState state = level.getBlockState(pos);
        for (count = 0; count < amount && this.canStateBeSpreaded(state); ++count) {
            state = this.getSpreadedState(state);
        }
        if (count > 0) {
            level.setBlock(pos, state, 3);
        }
        return count;
    }

    public boolean spend(LevelAccessor level, BlockPos pos) {
        return this.spend(level, pos, 1) == 1;
    }

    protected int pumpActiveFilters(LevelAccessor level, BlockPos pos, int amount) {
        BlockEntity tile;
        int count = 0;
        if (count >= amount || level.isClientSide()) {
            return count;
        }
        Block block = level.getBlockState(pos).getBlock();
        if (block instanceof IFilterFrame && (tile = level.getBlockEntity(pos)) != null) {
            ISmokeContainer container;
            IFilterFrame filter = (IFilterFrame)block;
            if ((count += filter.fill(tile, this, amount - count)) >= amount) {
                return count;
            }
            if (block instanceof ISmokeContainer && (container = (ISmokeContainer)block).isChimney() && container.isActive((BlockGetter)level, pos)) {
                count += this.pumpActiveFilters(level, pos.above(), amount - count);
            }
        }
        return count;
    }

    public int pumpEntitiesAt(LevelAccessor level, BlockPos pos, int amount) {
        AbstractCarrier entity;
        int count = 0;
        if (count >= amount || level.isClientSide()) {
            return count;
        }
        if ((count += this.pumpActiveFilters(level, pos, amount - count)) >= amount) {
            return count;
        }
        List<AbstractCarrier> foundCarriers = this.getPollutantCarriersAt((EntityGetter)level, pos);
        if (foundCarriers.isEmpty() && (entity = (AbstractCarrier)this.spawnEntity(level, pos).orElse(null)) != null && entity.isAlive()) {
            if (++count >= amount) {
                return count;
            }
            foundCarriers.add(entity);
        }
        for (AbstractCarrier carrier : foundCarriers) {
            if (!carrier.carriesSameBlock(Optional.of(this))) continue;
            while (carrier.pump()) {
                if (++count < amount) continue;
                return count;
            }
        }
        return count;
    }

    public int spendEntitiesAt(LevelAccessor level, BlockPos pos, int amount) {
        int count = 0;
        if (count >= amount || level.isClientSide()) {
            return count;
        }
        for (AbstractCarrier carrier : this.getPollutantCarriersAt((EntityGetter)level, pos)) {
            if (!carrier.carriesSameBlock(Optional.of(this))) continue;
            while (carrier.spend()) {
                if (++count < amount) continue;
                return count;
            }
        }
        return count;
    }

    public void scheduleUpdate(Level level, BlockPos pos) {
        level.scheduleTick(pos, (Block)this, this.getTickDelay(level, pos));
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (this.getCarriedPollutionAmount(state) <= 0) {
            return;
        }
        if (!level.isPositionEntityTicking(pos)) {
            return;
        }
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        boolean spreaded = false;
        BiomeId biome = BiomeId.from((LevelAccessor)level, (BlockPos)pos);
        Optional<Direction> motionFacing = this.getMotionFacing((LevelAccessor)level, pos, biome);
        if (motionFacing.isPresent()) {
            Direction output;
            BlockPos nextPos = pos.relative(motionFacing.get());
            BlockPos nextPos2 = pos.relative(motionFacing.get(), 2);
            Direction input = motionFacing.get().getOpposite();
            if (this.canPassThrough((LevelReader)level, nextPos, input, output = motionFacing.get()) && this.canPassThrough((LevelReader)level, nextPos2, input, output)) {
                switch (this.getCarrierSpawnTime(level, nextPos)) {
                    case NOW: {
                        int count = this.pumpEntitiesAt((LevelAccessor)level, nextPos, this.getCarriedPollutionAmount(state));
                        spreaded = count > 0 && this.spend((LevelAccessor)level, pos, count) == count;
                        break;
                    }
                    default: {
                        spreaded = this.tryReachInstantly(state, level, pos, this.getConcentrationAltitudeIn(biome));
                    }
                }
            }
        }
        if (!spreaded) {
            spreaded = this.spread(level, pos, state);
        }
        if (!spreaded) {
            for (Direction direction : GameWorld.Directions.of().all().shuffle().toArray()) {
                BlockState newState = this.tryAffectBlockAt(level, pos.relative(direction), Optional.of(direction.getOpposite()), AbstractPollutionImpacts.ImpactType.CONTACT, state);
                if (newState == state) continue;
                level.setBlockAndUpdate(pos, newState);
                state = newState;
                if (!GameWorld.isAirBlock((LevelReader)level, (BlockPos)pos)) {
                    this.scheduleUpdate((Level)level, pos);
                }
                return;
            }
        }
    }

    protected boolean tryReachInstantly(BlockState state, ServerLevel level, BlockPos startPos, int targetAltitude) {
        int distance;
        if (startPos.getY() == targetAltitude) {
            return true;
        }
        int dy = targetAltitude > startPos.getY() ? 1 : -1;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos().set((Vec3i)startPos);
        int y = startPos.getY();
        do {
            pos.setY(y += dy);
            if (level.isOutsideBuildHeight(y)) {
                return level.removeBlock(startPos, false);
            }
            if (level.isEmptyBlock((BlockPos)pos)) continue;
            pos.setY(y - dy);
            break;
        } while (y != targetAltitude && (distance = Math.abs(startPos.getY() - y)) < 256);
        if (pos.getY() != startPos.getY() && level.isEmptyBlock((BlockPos)pos)) {
            return level.setBlockAndUpdate(pos.immutable(), state) && level.removeBlock(startPos, false);
        }
        return false;
    }

    protected AbstractCarrier.SpawnTime getCarrierSpawnTime(ServerLevel level, BlockPos pos) {
        ChunkBounds chunkBounds = ChunkBounds.from((LevelHeightAccessor)level, (ChunkPos)new ChunkPos(pos));
        int count = level.getEntitiesOfClass(this.entityClass, chunkBounds.toAABB()).size();
        int max = (Integer)GasEntity.maxGasEntitiesInChunk.get();
        if (max < 1) {
            return AbstractCarrier.SpawnTime.NEVER;
        }
        if (count < max) {
            return AbstractCarrier.SpawnTime.NOW;
        }
        return AbstractCarrier.SpawnTime.LATER;
    }

    protected boolean spread(ServerLevel level, BlockPos pos, BlockState state) {
        return this.createSpread(level, pos, state).inMotionFacing().overLedge().around(2).apply();
    }

    public Spread createSpread(ServerLevel level, BlockPos pos, BlockState state) {
        return Spread.from(level, pos, state, this);
    }

    public boolean canStateBePumped(BlockState state) {
        return state.isAir() || this.isSamePollutant(state) && ((Density)((Object)state.getValue(DENSITY))).canAbsorb();
    }

    public boolean canStateBeSpreaded(BlockState state) {
        return this.getCarriedPollutionAmount(state) > 0;
    }

    public BlockState getPumpedState(BlockState state) {
        if (state.isAir()) {
            return this.defaultBlockState();
        }
        Density density = (Density)((Object)state.getValue(DENSITY));
        return (BlockState)state.setValue(DENSITY, (Comparable)((Object)density.getPumped()));
    }

    public BlockState getSpreadedState(BlockState state) {
        Density density = (Density)((Object)state.getValue(DENSITY));
        return density.canSpread() ? (BlockState)state.setValue(DENSITY, (Comparable)((Object)density.getSpreaded())) : Blocks.AIR.defaultBlockState();
    }

    public abstract int emitFrom(BlockEntity var1, Set<BlockState> var2, int var3);

    public int generateAt(WorldGenLevel level, BlockPos startPos, int amount, int maximumRadius) {
        int count = 0;
        int capacity = this.getPollutionCapacity();
        for (int maxRadius = 0; maxRadius <= maximumRadius && count < amount; ++maxRadius) {
            for (int vertOffset = 0; vertOffset <= maxRadius; ++vertOffset) {
                for (BlockPos planePos : new BlockPos[]{startPos.above(vertOffset), startPos.below(vertOffset)}) {
                    int rmax = maxRadius - vertOffset;
                    int rmin = rmax - capacity + 1;
                    if (rmin < 0) {
                        rmin = 0;
                    }
                    if (rmax < 0 || level.isOutsideBuildHeight(planePos)) continue;
                    for (int radius = rmin; radius <= rmax; ++radius) {
                        List posList = GameWorld.Positions.getAroundHoriz((BlockPos)planePos, (int)radius, (boolean)false);
                        Collections.shuffle(posList);
                        for (BlockPos pos : posList) {
                            if (level.getBlockState(pos).is(BlockTags.FIRE)) {
                                pos = pos.above();
                            }
                            count += this.pump((LevelAccessor)level, pos, amount - count);
                        }
                        if (count < amount) continue;
                        return count;
                    }
                }
            }
        }
        return count;
    }

    protected boolean setPollutantBlock(Level level, BlockPos pos) {
        return level.setBlockAndUpdate(pos, this.defaultBlockState());
    }

    protected abstract E createEntityPollutant(ServerLevel var1, BlockPos var2, BlockState var3);

    protected Optional<E> spawnEntity(LevelAccessor level, BlockPos pos) {
        return this.spawnEntity(level, pos, this.defaultBlockState());
    }

    protected Optional<E> spawnEntity(LevelAccessor level, BlockPos pos, BlockState carriedState) {
        if (level instanceof ServerLevel) {
            E entity = this.createEntityPollutant((ServerLevel)level, pos, carriedState);
            if (level.addFreshEntity(entity)) {
                return Optional.of(entity);
            }
        } else {
            AdPother.getInstance().getLogger().error("Attempt to spawn pollutant on client!");
        }
        return Optional.empty();
    }

    public boolean isSamePollutant(BlockState state) {
        return state.getBlock() == this;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{DENSITY});
    }

    public boolean skipRendering(BlockState state, BlockState adjacentBlockState, Direction side) {
        return this.isSamePollutant(adjacentBlockState) && this.getCarriedPollutionAmount(state) == this.getCarriedPollutionAmount(adjacentBlockState);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (level instanceof ServerLevel) {
            this.scheduleUpdate(level, pos);
        }
    }

    protected void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, @Nullable Orientation orientation, boolean isMoving) {
        this.scheduleUpdate(level, pos);
    }

    public int getTickDelay(Level level, BlockPos pos) {
        return CommonMath.Random.between((int)20, (int)120);
    }

    public boolean canBeReplaced(BlockState state, BlockPlaceContext useContext) {
        return state.getValue(DENSITY) != Density.HEAVY;
    }

    public int getCarriedPollutionAmount(BlockState state) {
        if (this.isSamePollutant(state)) {
            Density density = (Density)((Object)state.getValue(DENSITY));
            return density.ordinal() + 1;
        }
        return 0;
    }

    public int getPollutionCapacity() {
        return Density.values().length;
    }

    public ColorARGB getColor() {
        return this.color;
    }

    public boolean canAffectEntity(Entity entity, AbstractPollutionImpacts.ImpactType impact, Percentage pollution) {
        return AdPother.getInstance().impacts.getFor(entity).map(impacts -> impacts.canAffect(entity, this, impact, pollution)).orElse(false);
    }

    public boolean tryAffectEntity(Entity entity, AbstractPollutionImpacts.ImpactType impact, Percentage pollution) {
        return AdPother.getInstance().impacts.getFor(entity).map(impacts -> impacts.tryAffect(entity, this, impact, pollution) > 0).orElse(false);
    }

    public List<E> getPollutantCarriersAt(EntityGetter reader, BlockPos pos) {
        return reader.getEntitiesOfClass(this.entityClass, FULL_BLOCK_AABB.move(pos));
    }

    public Map<ItemStack, IStorageItem> getProtectiveItems(LivingEntity living) {
        return Collections.emptyMap();
    }

    public ChatFormatting getTextColor() {
        return this.textColor;
    }

    public int getCriticalAmountIn(BiomeId biome) {
        return (Integer)this.criticalAmount.get((Object)biome);
    }

    public int getConcentrationAltitudeIn(BiomeId biome) {
        return (Integer)this.concentrationAltitude.get((Object)biome);
    }

    public float getMotionVelocityIn(BiomeId biome) {
        return ((Float)this.motionVelocity.get((Object)biome)).floatValue();
    }

    public List<MultiConfigProperty.BaseProperty<BiomeId, ?>> getBiomeProperties() {
        return Collections.unmodifiableList(this.biomeProperties);
    }

    public float getEmissionRateIn(BiomeId biome) {
        return ((Float)this.emissionRate.get((Object)biome)).floatValue();
    }

    public FilterMaterialList getFilterMaterials() {
        return this.filterMaterials;
    }

    public boolean canSpreadOverLedge() {
        return true;
    }

    public boolean canSpreadAround() {
        return true;
    }

    @SafeVarargs
    protected final void addBiomeIdProperties(MultiConfigProperty.BaseProperty<BiomeId, ?> ... properties) {
        Collections.addAll(this.biomeProperties, properties);
    }

    public boolean canAffectBlock(LevelAccessor world, BlockPos pos, BlockState state, Optional<Direction> side, AbstractPollutionImpacts.ImpactType impact) {
        return ((EnvironmentalImpacts)AdPother.getInstance().impacts.environmentalImpacts.get()).canAffect(state, this, impact);
    }

    public final BlockState tryAffectBlockAt(ServerLevel world, BlockPos pos, Optional<Direction> side, AbstractPollutionImpacts.ImpactType type, BlockState sourceState) {
        if (!this.isSamePollutant(sourceState)) {
            return sourceState;
        }
        BlockState state = world.getBlockState(pos);
        if (this.tryFilterAt(world, pos, state, side)) {
            return this.getSpreadedState(sourceState);
        }
        if (!this.canAffectBlock((LevelAccessor)world, pos, state, side, type)) {
            return sourceState;
        }
        return this.affectBlockAt(world, pos, state, side, type, sourceState);
    }

    protected BlockState affectBlockAt(ServerLevel world, BlockPos pos, BlockState state, Optional<Direction> side, AbstractPollutionImpacts.ImpactType type, BlockState sourceState) {
        if (((EnvironmentalImpacts)AdPother.getInstance().impacts.environmentalImpacts.get()).tryAffect(world, pos, state, this, type)) {
            return this.getSpreadedState(sourceState);
        }
        return sourceState;
    }

    protected boolean tryFilterAt(ServerLevel world, BlockPos pos, BlockState state, Optional<Direction> side) {
        Block block = state.getBlock();
        if (block instanceof IFilterFrame) {
            if (side.isPresent() && state.isFaceSturdy((BlockGetter)world, pos, side.get())) {
                return false;
            }
            IFilterFrame filter = (IFilterFrame)block;
            BlockEntity tile = world.getBlockEntity(pos);
            if (tile != null) {
                return filter.fill(tile, this, 1) > 0;
            }
        }
        return false;
    }

    public Percentage getPercentageAtChunk(ServerLevel world, BlockPos pos) {
        BiomeId biome = BiomeId.from((LevelAccessor)world, (BlockPos)pos);
        PollutionInfo info = WorldData.getChunkPollution((Level)world, pos).getOrCreateInfoFor(this);
        return info.getPercentageIn(biome);
    }

    public boolean isUnderRainOrStorm(LevelAccessor world, BlockPos pos) {
        if (world.getLevelData().isRaining() || world.getLevelData().isThundering()) {
            BlockPos checkPos = pos.above();
            ChunkPos chunkPos = new ChunkPos(checkPos);
            if (world.getChunkSource().hasChunk(chunkPos.x, chunkPos.z)) {
                int height = world.getHeight(Heightmap.Types.MOTION_BLOCKING, checkPos.getX(), checkPos.getZ());
                return height <= checkPos.getY();
            }
        }
        return false;
    }

    public static class Properties<T extends Properties<T>>
    extends ForgeBlock.Properties<T> {
        public final MapColor mapColor;
        public ChatFormatting textColor = ChatFormatting.WHITE;
        public int criticalAmount = 0;
        public int concentrationAltitude = 0;
        public float motionVelocity = 0.0f;

        public static Properties<?> of(ResourceKey<Block> blockId, MapColor color) {
            return new Properties<Properties>(Properties.class, blockId, color);
        }

        protected Properties(Class<T> selfClass, ResourceKey<Block> blockId, MapColor color) {
            super(selfClass, blockId);
            this.mapColor = color;
            this.vanillaProps.mapColor(color).randomTicks();
        }

        public T textColor(ChatFormatting color) {
            this.textColor = color;
            return (T)((Object)((Properties)this.self));
        }

        public T criticalAmount(int amount) {
            this.criticalAmount = amount;
            return (T)((Object)((Properties)this.self));
        }

        public T concentrationAltitude(int altitude) {
            this.concentrationAltitude = altitude;
            return (T)((Object)((Properties)this.self));
        }

        public T motionVelocity(float velocity) {
            this.motionVelocity = velocity;
            return (T)((Object)((Properties)this.self));
        }
    }

    public static enum Density implements IForgeEnum
    {
        LIGHT,
        MEDIUM,
        HEAVY;


        public boolean canSpread() {
            return this.ordinal() > 0;
        }

        public boolean canAbsorb() {
            return this.ordinal() < Density.values().length - 1;
        }

        public Density getSpreaded() {
            return Density.values()[this.ordinal() - 1];
        }

        public Density getPumped() {
            return Density.values()[this.ordinal() + 1];
        }

        public String toString() {
            return this.getName();
        }
    }
}

