/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.common.CommonMath;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.INBTSource;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.sources.AbstractRocket;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class AdAstra {

    public static class Rocket
    extends AbstractRocket {
        public static Emitter.Properties<?> properties(int tier) {
            return ((Emitter.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.entity("#hardcoded", WorldEvents.Alignment.BOTTOM).carbon(250.0f * (float)tier))).sulfur(25.0f * (float)tier))).customFactory(Rocket::new);
        }

        public Rocket(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
        }

        public boolean isActive(INBTSource<?> nbtSource) {
            CompoundTag compound = nbtSource.serialize();
            return compound.getBooleanOr("HasLaunched", false) || compound.getBooleanOr("Launching", false);
        }

        @Override
        public int getMaxRadius() {
            return 3;
        }

        @Override
        public int getMaxEmitPositions() {
            return CommonMath.Random.between((int)1, (int)this.getMaxRadius());
        }

        @Override
        protected float getRate() {
            return 1.0f;
        }
    }

    public static class Rover
    extends Emitter {
        public static Emitter.Properties<?> properties() {
            return ((Emitter.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.entity("#hardcoded", WorldEvents.Alignment.BACK).carbon(4.0f))).sulfur(0.4f))).customFactory(Rover::new);
        }

        public Rover(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
        }

        public boolean isActive(INBTSource<?> nbtSource) {
            if (nbtSource.source().isEmpty()) {
                return false;
            }
            boolean isMoving = nbtSource.source().filter(Entity.class::isInstance).map(Entity.class::cast).map(Entity::getFirstPassenger).filter(Player.class::isInstance).map(Player.class::cast).map(player -> (double)Math.abs(player.zza) > 0.01).orElse(false);
            CompoundTag compound = nbtSource.serialize();
            float speed = compound.getFloatOr("Speed", 0.0f);
            return isMoving && !CommonMath.isAlmostZero((double)speed);
        }
    }
}

