/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.INBTSource;
import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.LavaTouchingWater;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import java.util.AbstractCollection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;

public class Create {
    public static final String MOD_ID = "create";
    public static ModConfigSpec.ConfigValue<Boolean> fanProcessingEmissions;
    private static final Lazy<Optional<Create>> INSTANCE;
    private final Class<?> allFanProcessingTypes = Class.forName("com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes");
    private final Object blastingType = this.allFanProcessingTypes.getField("BLASTING").get(null);
    private final Object smokingType = this.allFanProcessingTypes.getField("SMOKING").get(null);

    private Create() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
    }

    public boolean isCombustionFanProcessingType(Object processingType) {
        return processingType == this.blastingType || processingType == this.smokingType;
    }

    public static Optional<Create> getInstance() {
        return (Optional)INSTANCE.get();
    }

    public static final void handleFanProcessing(ItemEntity itemEntity, Object processingType) {
        if (((Boolean)fanProcessingEmissions.get()).booleanValue()) {
            Create.getInstance().filter(create -> create.isCombustionFanProcessingType(processingType)).ifPresent(create -> WorldEvents.onItemBurned(itemEntity.getItem(), itemEntity.level(), itemEntity.blockPosition()));
        }
    }

    public static final void handleAirCurrent(Level level, BlockPos pos, Direction direction, boolean pushing) {
        ServerLevel serverLevel;
        BlockState state;
        Block block;
        if (level instanceof ServerLevel && (block = (state = (serverLevel = (ServerLevel)level).getBlockState(pos)).getBlock()) instanceof AbstractGas) {
            AbstractGas gas = (AbstractGas)block;
            gas.createSpread(serverLevel, pos, state).inDirectionForced(pushing ? direction : direction.getOpposite()).inDirectionsForced(() -> GameWorld.Directions.of().all().remove(new Direction[]{direction, direction.getOpposite()}).shuffle()).apply();
        }
    }

    public static final void handleFluidCollision(Level level, BlockPos pos, Fluid firstFluid, Fluid secondFluid) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (firstFluid.is(FluidTags.LAVA) && (secondFluid == Fluids.WATER || secondFluid == Fluids.FLOWING_WATER) || secondFluid.is(FluidTags.LAVA) && (firstFluid == Fluids.WATER || firstFluid == Fluids.FLOWING_WATER)) {
                ((LavaTouchingWater)((Object)AdPother.getInstance().sources.lavaTouchingWater.get())).emitAt((Level)serverLevel, pos);
            }
        }
    }

    public static Emitter.Properties<?> boiler() {
        UnitId boilerID = UnitId.from((String)MOD_ID, (String)"fluid_tank").withMetaAll();
        UnitId engineID = UnitId.from((String)MOD_ID, (String)"steam_engine").withMetaAll();
        return (Emitter.Properties)((Object)((Emitter.Properties)((Object)((SourceBase.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.tile("").id(boilerID).customFactory(Boiler::new))).relatedBlocks(boilerID.toString(), engineID.toString()))).carbon(1.0f))).sulfur(0.1f));
    }

    public static Emitter.Properties<?> blazeBurner() {
        return (Emitter.Properties)((Object)((Emitter.Properties)((Object)((SourceBase.Properties)((Object)Emitter.Properties.tile("burnTimeRemaining").enumIdAsRelatedBlocks())).carbon(1.0f))).sulfur(0.1f));
    }

    public static Emitter.Properties<?> fuelBurner() {
        return Emitter.Properties.fuel("BurnTime");
    }

    public static Emitter.Properties<?> crushingWheel() {
        return (Emitter.Properties)((Object)((SourceBase.Properties)((Object)Emitter.Properties.tile("Inventory/ProcessingTime").customFactory(CrushingWheel::new))).dust(4.0f));
    }

    public static Emitter.Properties<?> millstone() {
        return (Emitter.Properties)((Object)((SourceBase.Properties)((Object)Emitter.Properties.tile("Timer").customFactory(Millstone::new))).dust(1.0f));
    }

    static {
        INSTANCE = AbstractForgeMod.singletonInstance((String)MOD_ID, Create.class);
    }

    public static abstract class AbstractCrusher
    extends Emitter {
        public AbstractCrusher(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
        }

        protected abstract Optional<CompoundTag> getInventoryTag(CompoundTag var1);

        public boolean isActive(INBTSource<?> nbtSource) {
            if (super.isActive(nbtSource)) {
                CompoundTag compound = nbtSource.serialize();
                float speed = compound.getFloatOr("Speed", 0.0f);
                if (speed == 0.0f) {
                    return false;
                }
                return this.getInventoryTag(compound).flatMap(tag -> tag.getList("Items")).map(AbstractCollection::size).filter(items -> items > 0).isPresent();
            }
            return false;
        }
    }

    public static class CrushingWheel
    extends AbstractCrusher {
        public CrushingWheel(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
        }

        @Override
        protected Optional<CompoundTag> getInventoryTag(CompoundTag compound) {
            return TagHelper.getNestedCompound((CompoundTag)compound, (String)"Inventory");
        }
    }

    public static class Millstone
    extends AbstractCrusher {
        public Millstone(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
        }

        @Override
        protected Optional<CompoundTag> getInventoryTag(CompoundTag compound) {
            return TagHelper.getNestedCompound((CompoundTag)compound, (String)"InputInventory");
        }
    }

    public static class Boiler
    extends Emitter {
        public Boiler(@Nullable UnitConfig config, Emitter.Properties<?> props) {
            super(config, (Emitter.Properties<?>)((Object)props.activeTag("#hardcoded_heat_check")));
        }

        public boolean isActive(INBTSource<?> nbtSource) {
            CompoundTag boiler = nbtSource.serialize().getCompoundOrEmpty("Boiler");
            boolean hasSupply = boiler.getFloatOr("Supply", 0.0f) >= 10.0f;
            boolean hasHeat = boiler.getBooleanOr("PassiveHeat", false) || boiler.getIntOr("ActiveHeat", 0) > 0;
            return hasSupply && hasHeat;
        }
    }
}

