/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.data;

import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.init.Materials;
import com.endertech.minecraft.mods.adpother.recipes.FilterChangeRecipe;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.SpecialRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;

public class ModRecipes
extends RecipeProvider {
    public ModRecipes(HolderLookup.Provider lookupProvider, RecipeOutput recipeOutput) {
        super(lookupProvider, recipeOutput);
    }

    protected void aerometer(RecipeOutput output) {
        this.shaped(RecipeCategory.TOOLS, (ItemLike)this.mod().items.aerometer.get(), 1).pattern("R#R").pattern("LOL").pattern("CIC").define(Character.valueOf('R'), (ItemLike)Items.REPEATER).define(Character.valueOf('#'), Tags.Items.GLASS_PANES).define(Character.valueOf('L'), Tags.Items.LEATHERS).define(Character.valueOf('O'), (ItemLike)Items.COMPASS).define(Character.valueOf('C'), (ItemLike)Items.COMPARATOR).define(Character.valueOf('I'), (ItemLike)Items.STICK).unlockedBy("has_item", this.has((ItemLike)Items.COMPASS)).save(output);
    }

    protected void filterFrame(Materials material, RecipeOutput output) {
        this.shaped(RecipeCategory.TOOLS, (ItemLike)material.filterFrame.get(), 1).pattern("M#M").pattern("# #").pattern("M#M").define(Character.valueOf('M'), material.crafting).define(Character.valueOf('#'), Tags.Items.GLASS_PANES).unlockedBy("has_item", this.has(material.crafting)).save(output);
    }

    protected void respirator(Materials material, RecipeOutput output) {
        this.shaped(RecipeCategory.TOOLS, (ItemLike)material.respirator.get(), 1).pattern("BHB").pattern("LML").pattern("WVW").define(Character.valueOf('B'), (ItemLike)Items.GLASS_BOTTLE).define(Character.valueOf('H'), (ItemLike)Items.LEATHER_HELMET).define(Character.valueOf('L'), Tags.Items.LEATHERS).define(Character.valueOf('M'), material.crafting).define(Character.valueOf('W'), ItemTags.WOOL).define(Character.valueOf('V'), ItemTags.LEAVES).unlockedBy("has_item", this.has((ItemLike)Items.LEATHER_HELMET)).save(output);
    }

    protected void vacuumBag(Materials material, RecipeOutput output) {
        this.shaped(RecipeCategory.TOOLS, (ItemLike)material.vacuumBag.get(), 1).pattern("WLM").pattern("LCL").pattern("MLS").define(Character.valueOf('S'), Tags.Items.SLIME_BALLS).define(Character.valueOf('W'), ItemTags.WOOL).define(Character.valueOf('M'), material.crafting).define(Character.valueOf('C'), (ItemLike)Items.LEATHER_CHESTPLATE).define(Character.valueOf('L'), Tags.Items.LEATHERS).unlockedBy("has_item", this.has((ItemLike)Items.LEATHER_CHESTPLATE)).save(output);
    }

    protected void vacuumTube(Materials material, RecipeOutput output) {
        this.shaped(RecipeCategory.TOOLS, (ItemLike)material.vacuumTube.get(), 1).pattern("  S").pattern("BM ").pattern("RC ").define(Character.valueOf('S'), material.storage).define(Character.valueOf('B'), ItemTags.BUTTONS).define(Character.valueOf('M'), Tags.Items.INGOTS_IRON).define(Character.valueOf('R'), (ItemLike)Items.REPEATER).define(Character.valueOf('C'), (ItemLike)Items.COMPARATOR).unlockedBy("has_item", this.has(material.storage)).save(output);
    }

    private AdPother mod() {
        return AdPother.getInstance();
    }

    protected void buildRecipes() {
        this.aerometer(this.output);
        for (Materials material : Materials.values()) {
            this.respirator(material, this.output);
            this.filterFrame(material, this.output);
            this.vacuumBag(material, this.output);
            this.vacuumTube(material, this.output);
        }
        SpecialRecipeBuilder.special(bookCategory -> new FilterChangeRecipe(this.mod())).save(this.output, this.mod().recipeSerializers.filterChange.getId().toString());
    }
}

