/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.items;

import com.endertech.minecraft.forge.configs.IForgeEnum;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.mods.adpother.items.Aerometer;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class AerometerItemModelState
implements SelectItemModelProperty<State> {
    public static final Codec<State> VALUE_CODEC = StringRepresentable.fromValues(State::values);
    public static final SelectItemModelProperty.Type<AerometerItemModelState, State> TYPE = SelectItemModelProperty.Type.create((MapCodec)MapCodec.unit((Object)new AerometerItemModelState()), VALUE_CODEC);

    @Nullable
    public State get(ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed, ItemDisplayContext displayContext) {
        if (ForgeItem.isBroken((ItemStack)stack)) {
            return State.BROKEN;
        }
        Optional<Entity> carrier = Aerometer.getCarrierFor(stack);
        if (carrier.isPresent()) {
            EntityPollution pollution = WorldData.getEntityPollution(carrier.get());
            Optional<Percentage.Grade> grade = pollution.getDominantPollutant(pollutant -> true).map(pollution::getInfluenceOf).map(Percentage::getGrade);
            if (grade.isPresent()) {
                return switch (grade.get()) {
                    default -> throw new MatchException(null, null);
                    case Percentage.Grade.LOW -> State.GREEN;
                    case Percentage.Grade.MEDIUM -> State.YELLOW;
                    case Percentage.Grade.HIGH -> State.RED;
                };
            }
        }
        return null;
    }

    public Codec<State> valueCodec() {
        return VALUE_CODEC;
    }

    public SelectItemModelProperty.Type<? extends SelectItemModelProperty<State>, State> type() {
        return TYPE;
    }

    public static enum State implements IForgeEnum
    {
        BROKEN,
        GREEN,
        YELLOW,
        RED;

    }
}

