/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.pollution;

import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.client.Tooltip;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.pollution.IStorage;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.TooltipDisplay;

public interface IStorageItem
extends IStorage<ItemStack> {
    @Override
    default public IStorage.Content getContent(ItemStack storage) {
        CustomData data = (CustomData)storage.get(DataComponents.CUSTOM_DATA);
        return data != null ? IStorage.Content.from(data.copyTag()) : new IStorage.Content(0);
    }

    @Override
    default public void onContentChanged(IStorage.Content content, ItemStack storage) {
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)storage, content::writeToNBT);
    }

    default public void appendHoverText(ItemStack stack, Item.TooltipContext context, TooltipDisplay display, Consumer<Component> consumer, TooltipFlag flag) {
        IStorage.Content content = this.getContent(stack);
        Tooltip tip = Tooltip.of((AbstractForgeMod)AdPother.getInstance(), (String)"storage_item", consumer);
        tip.add(ChatFormatting.WHITE, "contents");
        AdPother.getInstance().pollutants.streamAll().filter(content::hasFilterFor).forEach(pollutant -> {
            Percentage fullness = content.getFullnessPercentageFor((Pollutant<?>)((Object)pollutant));
            tip.addRaw(String.valueOf(pollutant.getTextColor()) + pollutant.getName().getString() + ": " + fullness.toColoredText());
        });
        if (ForgeEndertech.isDebugMode()) {
            tip.add(ChatFormatting.WHITE, "capacity", (Object)content.getCapacity());
        }
    }
}

