/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.renderers;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.client.renderer.GlassMeterIndicatorsRenderer;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.items.Aerometer;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.serialization.MapCodec;
import java.awt.Color;
import java.util.Set;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.special.SpecialModelRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class AerometerIndicatorsRenderer
extends GlassMeterIndicatorsRenderer<Entity> {
    static final ColorARGB COLOR_RED = ColorARGB.from((Color)Color.RED);
    public static final MapCodec<SpecialModelRenderer.Unbaked> CODEC = MapCodec.unit((Object)new SpecialModelRenderer.Unbaked(){

        @Nullable
        public SpecialModelRenderer<?> bake(EntityModelSet modelSet) {
            return new AerometerIndicatorsRenderer(modelSet);
        }

        public MapCodec<? extends SpecialModelRenderer.Unbaked> type() {
            return CODEC;
        }
    });

    public AerometerIndicatorsRenderer(EntityModelSet modelSet) {
        super(modelSet);
    }

    @Nullable
    public Entity extractArgument(ItemStack stack) {
        return Aerometer.getCarrierFor(stack).orElse(null);
    }

    public void render(@Nullable Entity carrier, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, boolean hasFoilType) {
        if (carrier == null) {
            return;
        }
        EntityPollution pollution = WorldData.getEntityPollution(carrier);
        VertexConsumer builder = bufferSource.getBuffer(this.getRenderType());
        double needleOffset = 0.001;
        double offset = 0.001;
        poseStack.pushPose();
        poseStack.translate(0.5f, 0.5f, 0.5f);
        poseStack.translate(0.0f, 0.0f, -0.04f);
        poseStack.translate(0.0, 0.0, offset);
        for (Pollutant<?> pollutant : pollution.getPollutants().toList()) {
            float factor = pollution.getInfluenceOf(pollutant).toFraction();
            ColorARGB color = pollutant.getColor();
            poseStack.translate(0.0, 0.0, offset);
            this.renderNeedle(builder, poseStack, color, factor);
            poseStack.translate(0.0, 0.0, -offset);
            offset += 0.001;
        }
        if (pollution.hasExplosionRisk()) {
            this.renderExplosionRiskIndicator(builder, poseStack, COLOR_RED);
        }
        poseStack.popPose();
    }

    public void getExtents(Set<Vector3f> set) {
    }

    protected void renderExplosionRiskIndicator(VertexConsumer builder, PoseStack matrix, ColorARGB color) {
        float size = 0.3f;
        AerometerIndicatorsRenderer.addVertex((VertexConsumer)builder, (PoseStack)matrix, (ColorARGB)color, (float)0.0f, (float)0.3f, (float)0.5f, (float)0.0f);
        AerometerIndicatorsRenderer.addVertex((VertexConsumer)builder, (PoseStack)matrix, (ColorARGB)color, (float)-0.3f, (float)0.15f, (float)0.0f, (float)1.0f);
        AerometerIndicatorsRenderer.addVertex((VertexConsumer)builder, (PoseStack)matrix, (ColorARGB)color, (float)0.3f, (float)0.15f, (float)1.0f, (float)1.0f);
        AerometerIndicatorsRenderer.addVertex((VertexConsumer)builder, (PoseStack)matrix, (ColorARGB)color, (float)0.3f, (float)0.15f, (float)1.0f, (float)1.0f);
    }

    protected void renderNeedle(VertexConsumer builder, PoseStack matrix, ColorARGB color, float factor) {
        CommonMath.Angle angle = CommonMath.Angle.fromDegrees((double)(FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(180.0f)).interpolateDown(factor).floatValue() - 90.0f));
        matrix.pushPose();
        matrix.mulPose((Quaternionfc)new Quaternionf().rotateZ((float)angle.getRadians()));
        float sW = 0.05f;
        float sL = 0.35f;
        AerometerIndicatorsRenderer.addVertex((VertexConsumer)builder, (PoseStack)matrix, (ColorARGB)color, (float)-0.05f, (float)-0.07f, (float)0.0f, (float)0.0f);
        AerometerIndicatorsRenderer.addVertex((VertexConsumer)builder, (PoseStack)matrix, (ColorARGB)color, (float)0.05f, (float)-0.07f, (float)1.0f, (float)0.0f);
        AerometerIndicatorsRenderer.addVertex((VertexConsumer)builder, (PoseStack)matrix, (ColorARGB)color, (float)0.05f, (float)0.35f, (float)1.0f, (float)1.0f);
        AerometerIndicatorsRenderer.addVertex((VertexConsumer)builder, (PoseStack)matrix, (ColorARGB)color, (float)-0.05f, (float)0.35f, (float)0.0f, (float)1.0f);
        matrix.popPose();
    }
}

