/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.sources;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.EmitterWithCustomRate;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public abstract class AbstractRocket
extends EmitterWithCustomRate {
    public AbstractRocket(UnitConfig config, Emitter.Properties<?> props) {
        super(config, props);
    }

    public abstract int getMaxRadius();

    public abstract int getMaxEmitPositions();

    @Override
    public void emitAt(Level level, BlockPos startPos, float factor) {
        List<BlockPos> positions = AbstractRocket.findEmitPositions(level, startPos, this.getMaxRadius(), this.getMaxEmitPositions());
        for (BlockPos pos : positions) {
            super.emitAt(level, pos, factor / (float)positions.size());
        }
    }

    public static List<BlockPos> findEmitPositions(Level level, BlockPos startPos, int maxRadius, final int maxPositions) {
        IntBounds heightBounds = IntBounds.of((Integer)startPos.getY()).extend(Integer.valueOf(maxRadius));
        WorldSearch.VertCylinder searcher = new WorldSearch.VertCylinder((LevelAccessor)level, startPos, heightBounds, maxRadius){

            protected boolean isValidPath(BlockPos pos) {
                if (this.level.isEmptyBlock(pos)) {
                    return true;
                }
                if (this.lastUsedDirection == null) {
                    return true;
                }
                BlockPos last = pos.relative(this.lastUsedDirection.getOpposite());
                return !this.level.getBlockState(last).isFaceSturdy((BlockGetter)this.level, last, this.lastUsedDirection) && !this.level.getBlockState(pos).isFaceSturdy((BlockGetter)this.level, pos, this.lastUsedDirection.getOpposite());
            }

            protected boolean isValidBlock(BlockPos pos) {
                return this.level.isEmptyBlock(pos);
            }

            protected boolean onValidFound(BlockPos pos) {
                return this.getFound().size() < maxPositions;
            }
        };
        searcher.build();
        return searcher.getFound().elements();
    }
}

