/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.state.HumanoidRenderState;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public abstract class ChestWearItemLayer<S extends HumanoidRenderState, M extends HumanoidModel<S>>
extends RenderLayer<S, M> {
    protected final ItemModelResolver modelResolver;

    public ChestWearItemLayer(RenderLayerParent<S, M> layerParent, EntityRendererProvider.Context context) {
        super(layerParent);
        this.modelResolver = context.getItemModelResolver();
    }

    public ModelPart getChestRenderer() {
        return ((HumanoidModel)this.getParentModel()).body;
    }

    public abstract boolean shouldRender(ItemStack var1, S var2);

    public ItemStack getWearItem(S renderState) {
        return ((HumanoidRenderState)renderState).chestEquipment;
    }

    public void render(PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, S renderState, float limbSwing, float limbSwingAmount) {
        ItemStack wearItem = this.getWearItem(renderState);
        if (!this.shouldRender(wearItem, renderState)) {
            return;
        }
        poseStack.pushPose();
        if (((HumanoidRenderState)renderState).isBaby) {
            poseStack.translate(0.0, 0.03125, 0.0);
            poseStack.scale(0.7f, 0.7f, 0.7f);
            poseStack.translate(0.0, 1.0, 0.0);
        }
        this.getChestRenderer().translateAndRotate(poseStack);
        poseStack.translate(0.0, -0.25, 0.0);
        poseStack.mulPose((Quaternionfc)new Quaternionf().rotateY((float)Math.PI));
        poseStack.scale(0.625f, -0.625f, -0.625f);
        ItemStackRenderState itemRenderState = new ItemStackRenderState();
        this.modelResolver.updateForTopItem(itemRenderState, wearItem, ItemDisplayContext.HEAD, null, null, 0);
        itemRenderState.render(poseStack, bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
        poseStack.popPose();
    }
}

