/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.core;

import com.endertech.common.CommonMath;
import com.endertech.common.CommonString;
import com.endertech.common.FloatBounds;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.client.ItemModel;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.data.DataCollector;
import com.endertech.minecraft.forge.data.Namespace;
import com.endertech.minecraft.forge.data.ServerCommand;
import com.endertech.minecraft.forge.math.GameBounds;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.logging.LogUtils;
import java.lang.reflect.Constructor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.chunk.ChunkSectionLayer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.entity.state.PlayerRenderState;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.SingletonArgumentInfo;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.loading.FMLPaths;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.client.event.RegisterMenuScreensEvent;
import net.neoforged.neoforge.client.event.RegisterParticleProvidersEvent;
import net.neoforged.neoforge.client.extensions.common.RegisterClientExtensionsEvent;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.ModConfigSpec;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.slf4j.Logger;

public abstract class AbstractForgeMod {
    protected final List<Runnable> postInitRunnables = new ArrayList<Runnable>();
    protected final DeferredRegister<ArgumentTypeInfo<?, ?>> commandArgumentTypes;
    private final Logger logger;
    private final Namespace namespace;
    private final IEventBus modEventBus;
    private final ModContainer modContainer;

    public abstract String getId();

    public AbstractForgeMod(IEventBus modEventBus, ModContainer modContainer) {
        this.modEventBus = modEventBus;
        this.modContainer = modContainer;
        this.logger = LogUtils.getLogger();
        this.namespace = Namespace.of(this.getId());
        this.commandArgumentTypes = DeferredRegister.create((Registry)BuiltInRegistries.COMMAND_ARGUMENT_TYPE, (String)this.getId());
        this.commandArgumentTypes.register(modEventBus);
        if (this.getRequiredSide() == RequiredSide.BOTH) {
            ForgeNetMsg.enableSynchronization();
        }
        IEventBus forgeEventBus = this.getForgeEventBus();
        modEventBus.addListener(event -> this.commonInit());
        modEventBus.addListener(event -> {
            event.enqueueWork(this::runPostInitRunnables);
            event.enqueueWork(this::commonPostInit);
        });
        modEventBus.addListener(event -> this.configUpdated(event.getConfig()));
        modEventBus.addListener(event -> this.registerNetMessages(msg -> ((ForgeNetMsg)msg.get()).register(event.registrar("1"))));
        modEventBus.addListener(this::registerCapabilities);
        forgeEventBus.addListener(event -> this.tagsUpdated());
        modEventBus.addListener(event -> this.gatherData(new DataCollector(this, (GatherDataEvent)event)));
        forgeEventBus.addListener(event -> this.serverAboutToStart(event.getServer()));
        forgeEventBus.addListener(event -> this.serverStarting(event.getServer()));
        forgeEventBus.addListener(event -> this.serverStopped(event.getServer()));
        forgeEventBus.addListener(event -> this.registerCommands(ServerCommand.create(this, (CommandDispatcher<CommandSourceStack>)event.getDispatcher()), event.getBuildContext()));
        if (this.isClientSide()) {
            modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
            modEventBus.addListener(event -> this.gatherData(new DataCollector(this, (GatherDataEvent)event)));
            modEventBus.addListener(event -> this.clientInit());
            modEventBus.addListener(event -> this.clientReplaceModels(new ItemModel.RegistryWrapper(event.getBakingResult())));
            modEventBus.addListener(this::clientRegisterParticleProviders);
            modEventBus.addListener(event -> this.clientRegisterItemModelProperties(ItemModel.Properties.of(this)));
            modEventBus.addListener(event -> this.clientAddRenderLayers());
            modEventBus.addListener(event -> this.clientRegisterRenderers());
            modEventBus.addListener(this::clientRegisterMenuScreens);
            modEventBus.addListener(this::clientRegisterKeyMappings);
            modEventBus.addListener(this::clientBuildCreativeModeTab);
            modEventBus.addListener(this::clientRegisterClientExtensions);
        }
    }

    public boolean isClientSide() {
        return FMLEnvironment.dist.isClient();
    }

    public IEventBus getModEventBus() {
        return this.modEventBus;
    }

    public IEventBus getForgeEventBus() {
        return NeoForge.EVENT_BUS;
    }

    public ModContainer getModContainer() {
        return this.modContainer;
    }

    public void commonInit() {
    }

    public void commonPostInit() {
    }

    public void commonConfigInit(ConfigValueBuilder value) {
    }

    public void clientConfigInit(ConfigValueBuilder value) {
    }

    public void configUpdated(ModConfig config) {
    }

    public void clientInit() {
    }

    public void clientAddRenderLayers() {
    }

    public void clientBuildCreativeModeTab(BuildCreativeModeTabContentsEvent event) {
    }

    public void clientReplaceModels(ItemModel.RegistryWrapper registry) {
    }

    public void clientRegisterRenderers() {
    }

    public void clientRegisterParticleProviders(RegisterParticleProvidersEvent event) {
    }

    public void clientRegisterItemModelProperties(ItemModel.Properties<?> props) {
    }

    public void clientRegisterMenuScreens(RegisterMenuScreensEvent event) {
    }

    public void clientRegisterKeyMappings(RegisterKeyMappingsEvent event) {
    }

    public void clientRegisterClientExtensions(RegisterClientExtensionsEvent event) {
    }

    public void registerCommands(ServerCommand command, CommandBuildContext buildContext) {
    }

    public void registerCapabilities(RegisterCapabilitiesEvent event) {
    }

    public void registerNetMessages(Consumer<Supplier<ForgeNetMsg<?>>> consumer) {
    }

    public void gatherData(DataCollector collector) {
    }

    public void tagsUpdated() {
    }

    protected void serverAboutToStart(MinecraftServer server) {
    }

    protected void serverStarting(MinecraftServer server) {
    }

    protected void serverStopped(MinecraftServer server) {
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Namespace getNamespace() {
        return this.namespace;
    }

    public RequiredSide getRequiredSide() {
        return RequiredSide.BOTH;
    }

    public void addPostInitRunnable(Runnable method) {
        this.postInitRunnables.add(method);
    }

    protected <T extends Entity> void registerEntityRender(EntityType<T> entityType, EntityRendererProvider<? super T> rendererProvider) {
        EntityRenderers.register(entityType, rendererProvider);
    }

    protected <T extends BlockEntity> void registerTileRenderer(BlockEntityType<T> tileEntityType, BlockEntityRendererProvider<? super T> rendererProvider) {
        BlockEntityRenderers.register(tileEntityType, rendererProvider);
    }

    protected void runPostInitRunnables() {
        this.postInitRunnables.forEach(Runnable::run);
    }

    public void setRenderLayer(Block block, ChunkSectionLayer type) {
        ItemBlockRenderTypes.setRenderLayer((Block)block, (ChunkSectionLayer)type);
    }

    public void setRenderLayer(Fluid fluid, ChunkSectionLayer type) {
        ItemBlockRenderTypes.setRenderLayer((Fluid)fluid, (ChunkSectionLayer)type);
    }

    public void addPlayerRenderLayer(Function<PlayerRenderer, RenderLayer<PlayerRenderState, PlayerModel>> renderLayerFactory) {
        Collection renderers = Minecraft.getInstance().getEntityRenderDispatcher().getSkinMap().values();
        renderers.forEach(renderer -> {
            if (renderer instanceof PlayerRenderer) {
                PlayerRenderer playerRenderer = (PlayerRenderer)renderer;
                playerRenderer.addLayer((RenderLayer)renderLayerFactory.apply(playerRenderer));
            }
        });
    }

    public static boolean isLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    public static <T> Lazy<Optional<T>> singletonInstance(String modId, Class<T> instanceClass) {
        return Lazy.of(() -> {
            if (AbstractForgeMod.isLoaded(modId)) {
                try {
                    Constructor constructor = instanceClass.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    return Optional.of(constructor.newInstance(new Object[0]));
                }
                catch (Exception e) {
                    ForgeEndertech.debugMsg(e.toString());
                }
            }
            return Optional.empty();
        });
    }

    public Path getConfigsDir() {
        return FMLPaths.CONFIGDIR.get().resolve(this.getId());
    }

    protected void registerCommonConfig() {
        this.registerConfig(ModConfig.Type.COMMON, this::commonConfigInit, null);
    }

    protected void registerClientConfig() {
        if (FMLEnvironment.dist.isClient()) {
            this.registerConfig(ModConfig.Type.CLIENT, this::clientConfigInit, null);
        }
    }

    protected void registerConfig(ModConfig.Type type, Consumer<ConfigValueBuilder> init, @Nullable String fileName) {
        ConfigValueBuilder value = new ConfigValueBuilder();
        init.accept(value);
        ModConfigSpec spec = value.builder.build();
        if (CommonString.isNullOrEmpty(fileName)) {
            this.getModContainer().registerConfig(type, (IConfigSpec)spec);
        } else {
            this.getModContainer().registerConfig(type, (IConfigSpec)spec, fileName);
        }
    }

    protected <A extends ArgumentType<?>> void registerCommandArgumentType(String name, Class<A> clazz, Supplier<A> supplier) {
        ForgeNetMsg.enableSynchronization();
        this.commandArgumentTypes.register(name, () -> (SingletonArgumentInfo)ArgumentTypeInfos.registerByClass((Class)clazz, (ArgumentTypeInfo)SingletonArgumentInfo.contextFree((Supplier)supplier)));
    }

    public static enum RequiredSide {
        SERVER,
        CLIENT,
        BOTH;

    }

    public static class ConfigValueBuilder {
        public final ModConfigSpec.Builder builder = new ModConfigSpec.Builder();

        public ConfigValueBuilder push(String path) {
            this.builder.push(path);
            return this;
        }

        public ConfigValueBuilder pop() {
            this.builder.pop();
            return this;
        }

        public void shared(String path) {
            this.push(path);
            this.comment("These settings are shared between several mods and therefore located in forgeendertech-common.toml");
            String defaultValue = "I've read the hint and understood";
            this.defineList("whereAreTheSettings?", new String[]{"I've read the hint and understood"}, "I've read the hint and understood"::equals);
            this.pop();
        }

        public ConfigValueBuilder worldRestart() {
            this.builder.worldRestart();
            return this;
        }

        public ConfigValueBuilder comment(String comment) {
            this.builder.comment(comment);
            return this;
        }

        public ModConfigSpec.ConfigValue<Boolean> define(String path, boolean defaultValue) {
            return this.builder.define(path, defaultValue);
        }

        public ModConfigSpec.ConfigValue<Integer> define(String path, ColorARGB defaultValue) {
            return this.builder.define(path, (Object)defaultValue.getARGB());
        }

        public ModConfigSpec.ConfigValue<Integer> defineInRange(String path, int defaultValue, IntBounds bounds) {
            return this.builder.defineInRange(path, defaultValue, bounds.getMin().intValue(), bounds.getMax().intValue());
        }

        public ModConfigSpec.ConfigValue<Double> defineInRange(String path, float defaultValue, FloatBounds bounds) {
            int fractDigits = 6;
            return this.builder.defineInRange(path, CommonMath.roundTo(defaultValue, fractDigits), CommonMath.roundTo(bounds.getMin().floatValue(), fractDigits), CommonMath.roundTo(bounds.getMax().floatValue(), fractDigits));
        }

        public <T extends Enum<T>> ModConfigSpec.ConfigValue<T> defineEnum(String path, T defaultValue) {
            return this.builder.defineEnum(path, defaultValue);
        }

        public <T extends Enum<T>> ModConfigSpec.ConfigValue<T> defineEnum(String path, T defaultValue, Predicate<T> validator) {
            List<Enum> acceptableValues = Stream.of((Enum[])defaultValue.getDeclaringClass().getEnumConstants()).filter(validator).toList();
            return this.builder.defineEnum(path, defaultValue, acceptableValues);
        }

        public ModConfigSpec.ConfigValue<Double> defineFactor(String path, float defaultValue) {
            return this.defineInRange(path, defaultValue, GameBounds.FACTOR.getFloatBounds());
        }

        public ModConfigSpec.ConfigValue<List<? extends String>> defineList(String path, String[] defaultValues, Predicate<String> validator) {
            return this.builder.defineListAllowEmpty(List.of(path), () -> List.of(defaultValues), object -> {
                String string;
                return object instanceof String && validator.test(string = (String)object);
            });
        }
    }
}

