/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.minecraft.forge.world.Biomes;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;

public class BiomeId {
    public static final BiomeId EMPTY = new BiomeId(Optional.empty());
    protected final Optional<ResourceKey<Biome>> key;

    protected BiomeId(Optional<ResourceKey<Biome>> resourceKey) {
        this.key = resourceKey;
    }

    public static BiomeId from(ResourceKey<Biome> resourceKey) {
        return new BiomeId(Optional.of(resourceKey));
    }

    public static BiomeId from(LevelAccessor level, BlockPos pos) {
        Optional resourceKey = level.getBiome(pos).unwrapKey();
        return new BiomeId(resourceKey);
    }

    public static BiomeId from(ResourceLocation location) {
        ResourceKey resourceKey = ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)location);
        return new BiomeId(Optional.of(resourceKey));
    }

    public boolean isEmpty() {
        return this.getKey().isEmpty();
    }

    public Optional<ResourceKey<Biome>> getKey() {
        return this.key;
    }

    public Optional<ResourceLocation> getResourceLocation() {
        return this.getKey().map(ResourceKey::location);
    }

    public Optional<Biome> getBiome() {
        if (this.getKey().isPresent()) {
            return Biomes.registries().map(reg -> reg.get(this.getKey().get())).filter(Optional::isPresent).map(Optional::get).filter(Holder.Reference::isBound).map(Holder.Reference::value).findFirst();
        }
        return Optional.empty();
    }

    public String toString() {
        return this.getResourceLocation().map(ResourceLocation::toString).orElse(super.toString());
    }

    public boolean equals(Object obj) {
        if (obj instanceof BiomeId) {
            return Objects.equals(this.getKey(), ((BiomeId)obj).getKey());
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return Objects.hash(this.getKey());
    }
}

