function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/mrscauthd/beyond_earth/common/blocks/entities/machines/power/PowerSystemFuel',
		'methodName' : 'feed',
		'methodDesc' : '(Z)Z'
	}

	var node = {
		'class' : 'net/minecraftforge/items/IItemHandlerModifiable',
		'methodName' : 'extractItem', 
		'methodDesc' : '(IIZ)Lnet/minecraft/world/item/ItemStack;'
	}
	
	var getBlockEntity = {
		'class' : 'net/mrscauthd/beyond_earth/common/blocks/entities/machines/power/PowerSystem',
		'methodName' : 'getBlockEntity',
		'methodDesc' : '()Lnet/mrscauthd/beyond_earth/common/blocks/entities/machines/AbstractMachineBlockEntity;'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [
		insnDup("fuel stack"),
		insnPushValue(1, "fuel amount"),
		insnLoadThis("block entity"),
		insnInvokeVirtual(getBlockEntity),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsAfter(method, node, instructions);
				return method;
			}
		}
	}
}