function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'com/jesz/createdieselgenerators/blocks/entity/HugeDieselEngineBlockEntity',
		'methodName' : 'tick',
		'methodDesc' : '()V'
	}

	var node = {
		'class' : 'com/simibubi/create/foundation/fluid/FluidHelper',
		'methodName' : 'copyStackWithAmount',
		'methodDesc' : '(Lnet/minecraftforge/fluids/FluidStack;I)Lnet/minecraftforge/fluids/FluidStack;'
	}

	var tank = {
    	'class' : 'com/jesz/createdieselgenerators/blocks/entity/HugeDieselEngineBlockEntity',
    	'fieldName' : 'tank',
    	'fieldDesc' : 'Lcom/simibubi/create/foundation/blockEntity/behaviour/fluid/SmartFluidTankBehaviour;'
    }

    var getPrimaryHandler = {
    	'class' : 'com/simibubi/create/foundation/blockEntity/behaviour/fluid/SmartFluidTankBehaviour',
    	'methodName' : 'getPrimaryHandler',
    	'methodDesc' : '()Lcom/simibubi/create/foundation/fluid/SmartFluidTank;'
    }

    var getFluidStack = {
       	'class' : 'com/simibubi/create/foundation/fluid/SmartFluidTank',
       	'methodName' : 'getFluid',
       	'methodDesc' : '()Lnet/minecraftforge/fluids/FluidStack;'
    }

    var getFluid = {
       	'class' : 'net/minecraftforge/fluids/FluidStack',
       	'methodName' : 'getFluid',
      	'methodDesc' : '()Lnet/minecraft/world/level/material/Fluid;'
    }

    var getBurnRate = {
       	'class' : 'com/jesz/createdieselgenerators/other/FuelTypeManager',
       	'methodName' : 'getBurnRate',
      	'methodDesc' : '(Lnet/minecraft/world/level/block/entity/BlockEntity;Lnet/minecraft/world/level/material/Fluid;)I'
    }

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/minecraftforge/fluids/FluidStack;ILnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [ 
		insnDup("fuel fluidstack"),
		insnLoadThis("engine"),
		insnLoadThis("engine"),
		insnGetField(tank),
		insnInvokeVirtual(getPrimaryHandler),
		insnInvokeVirtual(getFluidStack),
		insnInvokeVirtual(getFluid),
		insnInvokeStatic(getBurnRate),
		insnLoadThis("engine"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsAfter(method, node, instructions);
				return method;
			}
		}
	}
}