function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'com/drmangotea/tfmg/blocks/engines/diesel/DieselEngineBlockEntity',
		'methodName' : 'engineProcess',
		'methodDesc' : '(Lnet/minecraft/core/Direction$Axis;Z)V'
	}

	var node = {
		'class' : 'net/minecraftforge/fluids/capability/templates/FluidTank',
		'methodName' : 'setFluid',
		'methodDesc' : '(Lnet/minecraftforge/fluids/FluidStack;)V'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/minecraftforge/fluids/FluidStack;ILnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [ 
		insnDup("fuel fluidstack"),
		insnPushValue(1, "fuel amount"),
		insnLoadThis("engine"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBefore(method, node, instructions);
				return method;
			}
		}
	}
}