function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'com/buuz135/industrial/block/agriculturehusbandry/tile/MobCrusherTile',
		'methodName' : 'instantKill',
		'methodDesc' : '(Lnet/minecraft/world/entity/Mob;Lnet/minecraftforge/common/util/FakePlayer;)Lcom/buuz135/industrial/block/tile/IndustrialWorkingTile$WorkAction;'
	}

	var node = {
		'class' : 'net/minecraft/world/entity/Mob',
		'methodName' : 'setHealth',
		'methodDesc' : '(F)V'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/compat/IndustrialForegoing$MobCrusher',
		'methodName' : 'onEntityInstantKill',
		'methodDesc' : '(Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/world/entity/player/Player;)V'
	}

	var instructions = [ 
		insnLoadObj(1, "mob"),
		insnLoadObj(2, "player"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsAfter(method, node, instructions);
				return method;
			}
		}
	}
}