function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/neoforged/neoforge/common/extensions/IBlockStateExtension',
		'methodName' : 'onBlockExploded',
		'methodDesc' : '(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/Explosion;)V'
	}

	var self = {
		'class' : 'net/neoforged/neoforge/common/extensions/IBlockStateExtension',
		'methodName' : 'self',
		'methodDesc' : '()Lnet/minecraft/world/level/block/state/BlockState;'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onBlockExploded',
		'methodDesc' : '(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/Explosion;)V'
	}

	var instructions = [ 
		insnLoadObj(1, "world"), 
		insnLoadObj(2, "pos"),
		insnLoadThis("IBlockStateExtension"),
		insnInvokeInterface(self),
		insnLoadObj(3, "explosion"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBeforeAll(method, instructions);
				return method;
			}
		}
	}
}