function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'mcjty/rftoolspower/modules/generator/blocks/CoalGeneratorTileEntity',
		'methodName' : 'handlePowerGeneration',
		'methodDesc' : '()V'
	}

	var node = {
		'class' : 'mcjty/lib/container/GenericItemHandler',
		'methodName' : 'extractItem',
		'methodDesc' : '(IIZ)Lnet/minecraft/world/item/ItemStack;'
	}
			
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [
	    insnDup("fuel"),
		insnPushValue(1, "fuel amount"),
		insnLoadThis("generator tile"), 
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsAfter(method, node, instructions);
				return method;
			}
		}
	}
}