/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.INBTSource;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class CreateTFMG {
    public static final String MOD_ID = "tfmg";

    public static Emitter.Properties<?> cokeOven() {
        UnitId id = UnitId.from((String)MOD_ID, (String)"coke_oven").withMetaAll();
        return ((Emitter.Properties)((Object)Emitter.Properties.fuel("").id(id).relatedBlocks(id.toString()))).customFactory(Machine::new);
    }

    public static Emitter.Properties<?> blastFurnace() {
        return Emitter.Properties.fuel("").id(UnitId.from((String)MOD_ID, (String)"blast_furnace_output").withMetaAll()).relatedBlocks(UnitId.from((String)MOD_ID, (String)"fireproof_bricks").withMetaAll().toString());
    }

    public static Emitter.Properties<?> flarestack() {
        return (Emitter.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.tile(BlockStateProperties.LIT).id(UnitId.from((String)MOD_ID, (String)"flarestack").withMetaAll()).carbon(1.0f))).sulfur(0.1f));
    }

    public static class Engine
    extends Machine {
        public Engine(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
        }

        public static Emitter.Properties<?> simple(String engineType) {
            UnitId engineId = UnitId.from((String)CreateTFMG.MOD_ID, (String)engineType).withNameSuffix("engine").withMetaAll();
            return Emitter.Properties.fuel("").id(engineId).customFactory(Engine::new);
        }

        public static Emitter.Properties<?> backed(String engineType) {
            Emitter.Properties<?> props = Engine.simple(engineType);
            return props.relatedBlocks(props.id.withNameSuffix("back").toString());
        }

        public static Emitter.Properties<?> expanded(String engineType) {
            Emitter.Properties<?> props = Engine.simple(engineType);
            return props.relatedBlocks(props.id.withNameSuffix("expansion").toString());
        }

        protected boolean hasBackPart(LevelAccessor level, BlockPos frontPartPos, Direction facingDirection) {
            if (!this.getRelatedBlocks().isEmpty()) {
                BlockPos pos = frontPartPos.relative(facingDirection.getOpposite());
                BlockState state = level.getBlockState(pos);
                return this.getRelatedBlocks().contains(state) && this.isFacing(facingDirection, state);
            }
            return false;
        }

        @Override
        public BlockPos getExhaustPosition(LevelAccessor level, INBTSource<?> nbtSource, BlockPos defaultPos) {
            Direction facingDirection = this.getFacingDirection(level.getBlockState(defaultPos)).orElse(null);
            if (facingDirection == null) {
                return defaultPos;
            }
            boolean hasBackPart = this.hasBackPart(level, defaultPos, facingDirection);
            BlockPos startPos = hasBackPart ? defaultPos.relative(facingDirection.getOpposite()) : defaultPos;
            List directions = hasBackPart ? Collections.singletonList(facingDirection.getOpposite()) : GameWorld.Directions.of().all().shuffle().toList();
            for (Direction direction : directions) {
                Optional<BlockPos> outlet;
                BlockPos pos = startPos.relative(direction);
                BlockState state = level.getBlockState(pos);
                if ((!this.isActivePump(level, pos) || !this.isFacing(direction, state)) && (!this.isPipe(level, pos) || !this.isConnectedTo(direction, state)) || !(outlet = this.getPipeOutlet(level, pos)).isPresent()) continue;
                return outlet.get();
            }
            return defaultPos;
        }
    }

    public static class Machine
    extends Emitter {
        private Class<?> pumpClass = null;
        private Class<?> pipeClass = null;
        private Class<?> exhaustClass = null;
        protected final int maxExhaustPipeLength;

        public Machine(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
            this.maxExhaustPipeLength = UnitConfig.getInt((UnitConfig)config, (String)this.getClassCategory(), (String)"maxExhaustPipeLength", (int)128, (IntBounds)IntBounds.between((Integer)1, (Integer)1024), (String)"The maximum length of the exhaust pipe.\nNote that high values affect performance");
            if (AbstractForgeMod.isLoaded((String)CreateTFMG.MOD_ID)) {
                try {
                    this.pumpClass = Class.forName("com.simibubi.create.content.fluids.pump.PumpBlockEntity");
                    this.pipeClass = Class.forName("com.simibubi.create.content.fluids.pipes.FluidPipeBlockEntity");
                    this.exhaustClass = Class.forName("com.drmangotea.tfmg.blocks.machines.exhaust.ExhaustBlockEntity");
                }
                catch (Exception e) {
                    ForgeEndertech.getInstance().getLogger().error(e.toString());
                }
            }
        }

        @Override
        public BlockPos getExhaustPosition(LevelAccessor level, INBTSource<?> nbtSource, BlockPos defaultPos) {
            if (nbtSource instanceof BlockEntity) {
                BlockEntity tile = (BlockEntity)nbtSource;
                WorldSearch.TileNeighbors neighbors = WorldSearch.TileNeighbors.from((BlockEntity)tile, this.getRelatedBlocks());
                for (BlockPos pos : neighbors.getAboveBlocks()) {
                    Optional<BlockPos> outlet;
                    BlockState state = level.getBlockState(pos);
                    if ((!this.isActivePump(level, pos) || !this.isFacing(Direction.UP, state)) && (!this.isPipe(level, pos) || !this.isConnectedTo(Direction.UP, state)) || !(outlet = this.getPipeOutlet(level, pos)).isPresent()) continue;
                    return outlet.get();
                }
            }
            return defaultPos;
        }

        protected boolean isActivePump(LevelAccessor level, BlockPos pos) {
            BlockEntity tile = level.getBlockEntity(pos);
            if (this.pumpClass != null && this.pumpClass.isInstance(tile)) {
                CompoundTag compound = INBTSource.of((BlockEntity)tile).serialize();
                float speed = compound.getFloat("Speed");
                return speed != 0.0f;
            }
            return false;
        }

        protected boolean isPipe(LevelAccessor level, BlockPos pos) {
            return this.pipeClass != null && this.pipeClass.isInstance(level.getBlockEntity(pos));
        }

        protected boolean isExhaust(LevelAccessor level, BlockPos pos) {
            return this.exhaustClass != null && this.exhaustClass.isInstance(level.getBlockEntity(pos));
        }

        protected boolean isFacing(Direction direction, BlockState state) {
            return this.stateHasValue(state, "facing", direction.getName());
        }

        protected boolean isConnectedTo(Direction face, BlockState state) {
            return this.stateHasValue(state, face.getOpposite().getName(), "true");
        }

        protected Optional<Direction> getFacingDirection(BlockState state) {
            for (Direction direction : GameWorld.Directions.of().horizontals().toArray()) {
                if (!this.isFacing(direction, state)) continue;
                return Optional.of(direction);
            }
            return Optional.empty();
        }

        protected boolean stateHasValue(BlockState state, String propertyName, String valueName) {
            Property property = state.getBlock().getStateDefinition().getProperty(propertyName);
            if (property != null && state.hasProperty(property)) {
                return property.getValue(valueName).filter(value -> value.equals(state.getValue(property))).isPresent();
            }
            return false;
        }

        protected Optional<BlockPos> getPipeOutlet(LevelAccessor level, BlockPos startPos) {
            WorldSearch.BlockChain pipe = new WorldSearch.BlockChain(level, startPos, this.maxExhaustPipeLength){

                protected Collection<Direction> getDirections() {
                    return GameWorld.Directions.of().all().shuffle().toList();
                }

                private boolean isValidDirection(BlockPos pos) {
                    if (this.lastUsedDirection != null) {
                        BlockPos prevPos = pos.relative(this.lastUsedDirection.getOpposite());
                        BlockState state = this.level.getBlockState(prevPos);
                        return this.isConnectedTo(this.lastUsedDirection.getOpposite(), state) || this.isFacing(this.lastUsedDirection, state);
                    }
                    return false;
                }

                protected boolean isValidPath(BlockPos pos) {
                    if (this.lastUsedDirection == null) {
                        return true;
                    }
                    if (this.isValidDirection(pos)) {
                        BlockState state = this.level.getBlockState(pos);
                        if (this.isPipe(this.level, pos) && this.isConnectedTo(this.lastUsedDirection, state)) {
                            return true;
                        }
                        if (this.isActivePump(this.level, pos) && this.isFacing(this.lastUsedDirection, state)) {
                            return true;
                        }
                    }
                    return false;
                }

                protected boolean isValidBlock(BlockPos pos) {
                    if (this.isValidDirection(pos)) {
                        BlockState state = this.level.getBlockState(pos);
                        if (state.isAir()) {
                            return true;
                        }
                        if (this.isExhaust(this.level, pos) && (this.isFacing(this.lastUsedDirection, state) || this.isFacing(this.lastUsedDirection.getOpposite(), state))) {
                            return true;
                        }
                    }
                    return false;
                }

                protected boolean onValidFound(BlockPos pos) {
                    return true;
                }
            };
            pipe.build();
            return pipe.getFound().stream().findFirst();
        }

        protected void debuglog(String msg) {
            ForgeEndertech.debugMsg((String)msg);
        }
    }
}

