/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.emissions;

import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.units.ITickableUnit;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public abstract class AbstractEntityEmission<N, M extends IEmitter>
implements ITickableUnit {
    protected final N entity;
    protected final GameTime updateInterval;
    protected final M emitter;
    protected boolean exists = true;

    protected AbstractEntityEmission(N entity, M emitter, GameTime updateInterval) {
        this.entity = entity;
        this.emitter = emitter;
        this.updateInterval = updateInterval;
    }

    public abstract BlockPos getEntityBlockPos();

    public N getEntity() {
        return this.entity;
    }

    public M getEmitter() {
        return this.emitter;
    }

    public GameTime getUpdateInterval() {
        return this.updateInterval;
    }

    public boolean exists() {
        return this.exists;
    }

    public boolean isInEntityTickingChunk() {
        Level level = this.getWorldLevel();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            BlockPos pos = this.getEntityBlockPos();
            return level2.isPositionEntityTicking(pos) && level2.isAreaLoaded(pos, 1);
        }
        return false;
    }

    public void kill() {
        this.exists = false;
    }
}

