/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.events;

import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.impacts.AbstractPollutionImpacts;
import com.endertech.minecraft.mods.adpother.init.Respirators;
import com.endertech.minecraft.mods.adpother.init.Sources;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.GasExplosion;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.sources.PlayerBurning;
import com.endertech.minecraft.mods.adpother.sources.PlayerDying;
import com.endertech.minecraft.mods.adpother.sources.PlayerEating;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;
import net.neoforged.neoforge.event.entity.living.LivingEntityUseItemEvent;
import net.neoforged.neoforge.event.entity.living.LivingEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="adpother")
public class PlayerEvents {
    private static final GameTime PLAYER_UPDATE_INTERVAL = GameTime.quaterSecond();
    private static final GameTime IGNITION_FROM_TORCH_CHECK_INTERVAL = GameTime.second();

    static Optional<ServerPlayer> getServerPlayer(LivingEvent event) {
        Optional<ServerPlayer> optional;
        ICancellableEvent cancellable;
        if (event instanceof ICancellableEvent && (cancellable = (ICancellableEvent)event).isCanceled()) {
            return Optional.empty();
        }
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            optional = Optional.of(player);
        } else {
            optional = Optional.empty();
        }
        return optional;
    }

    private static boolean affectedByPollution(Player player) {
        EntityPollution pollution = WorldData.getEntityPollution((Entity)player);
        return pollution.getPollutants().anyMatch(pollutant -> pollution.isHeadInPollutant((Pollutant<?>)((Object)pollutant)) || pollutant.canAffectEntity((Entity)player, AbstractPollutionImpacts.ImpactType.AIR, pollution.getInfluenceOf((Pollutant<?>)((Object)pollutant))));
    }

    @SubscribeEvent
    public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        Level level = event.getLevel();
        if (level instanceof ServerLevel) {
            BlockPos pos;
            BlockState state;
            ServerLevel level2 = (ServerLevel)level;
            if (event.getUseBlock() != TriState.FALSE && (state = level2.getBlockState(pos = event.getPos())).getBlock() == Blocks.CAKE) {
                PlayerEvents.getServerPlayer((LivingEvent)event).filter(pl -> pl.canEat(false)).ifPresent(pl -> ((PlayerEating)((Object)((Object)AdPother.getInstance().sources.playerEating.get()))).emitFrom(pl, 2.0f));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onFinishUsing(LivingEntityUseItemEvent.Finish event) {
        ItemStack stack = event.getItem();
        if (stack.getUseAnimation() == UseAnim.EAT) {
            PlayerEvents.getServerPlayer((LivingEvent)event).ifPresent(player -> ((PlayerEating)((Object)((Object)AdPother.getInstance().sources.playerEating.get()))).emitFrom((Player)player, stack));
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onDeath(LivingDeathEvent event) {
        Sources sources = AdPother.getInstance().sources;
        if (event.getSource().is(DamageTypeTags.IS_FIRE)) {
            PlayerEvents.getServerPlayer((LivingEvent)event).ifPresent(player -> ((PlayerBurning)((Object)((Object)sources.playerBurning.get()))).emitFrom(player, 1.0f));
        } else {
            PlayerEvents.getServerPlayer((LivingEvent)event).ifPresent(player -> ((PlayerDying)((Object)((Object)sources.playerDying.get()))).emitFrom(player, 1.0f));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onInventoryTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        if (player == null || stack.isEmpty()) {
            return;
        }
        Respirators.Respirator respirator = AdPother.getInstance().respirators.get(stack).orElse(null);
        if (respirator != null && player.level() != null) {
            respirator.appendHoverText(stack, Item.TooltipContext.of((Level)player.level()), event.getToolTip(), event.getFlags());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerBreaksBlock(BlockEvent.BreakEvent event) {
        if (event.isCanceled()) {
            return;
        }
        Player player = event.getPlayer();
        if (event.getPlayer().isCreative()) {
            return;
        }
        Level level = player.level();
        if (level == null || !GameWorld.isServerSide((LevelReader)level)) {
            return;
        }
        HolderLookup lookup = level.holderLookup(Registries.ENCHANTMENT);
        int silkTouchLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)lookup.getOrThrow(Enchantments.SILK_TOUCH), (ItemStack)player.getMainHandItem());
        if (silkTouchLevel > 0) {
            return;
        }
        BlockPos pos = event.getPos();
        BlockState state = level.getBlockState(pos);
        WorldEvents.onBlockBroken(level, pos, state);
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        ServerPlayer player;
        Player player2 = event.getEntity();
        if (player2 instanceof ServerPlayer && (player2 = (player = (ServerPlayer)player2).level()) instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)player2;
            if (IGNITION_FROM_TORCH_CHECK_INTERVAL.pastIn((Level)level)) {
                GasExplosion.fromHeldTorch((Player)player).tryExplode();
            }
            if (!PLAYER_UPDATE_INTERVAL.pastIn((Level)level)) {
                return;
            }
            EntityPollution pollution = WorldData.getEntityPollution((Entity)player);
            pollution.update();
            boolean explosionRisk = GasExplosion.in((Level)level).positions(GasExplosion.getIgnitablePositionsAround((Player)player, EnumSet.allOf(InteractionHand.class))).tryTrigger();
            pollution.setExplosionRisk(explosionRisk);
            new EntityPollution.NetMsg(pollution).sendToAllAround(level, player.blockPosition(), 64);
        }
    }
}

