/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.impacts;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.blocks.PollutedWater;
import com.endertech.minecraft.mods.adpother.chains.SoilChain;
import com.endertech.minecraft.mods.adpother.config.BlockImpactList;
import com.endertech.minecraft.mods.adpother.config.FluidBlockStateList;
import com.endertech.minecraft.mods.adpother.config.FluidImpactList;
import com.endertech.minecraft.mods.adpother.impacts.AbstractImpacts;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class FluidImpacts
extends AbstractImpacts {
    protected final FluidBlockStateList fluids;
    protected final FluidImpactList impacts;
    protected boolean canSpreadAcrossWater;
    protected boolean canSpreadThroughSoil;
    protected boolean canAffectUnderwaterBlocks;
    protected int maxWaterColumnPressure;
    protected int maxUnderwaterDistance;

    public FluidImpacts(UnitConfig config) {
        super(config);
        this.fluids = new FluidBlockStateList(config, this.getHeadCategory(), "fluids", new String[]{"#c:acetaldehyde", "#c:biodiesel", "#c:bioethanol", "#c:biofuel", "#c:chlorine", "#c:creosote", "#c:crude_oil", "#c:deuterium", "#c:diesel", "#c:ethanol", "#c:fuel", "#c:fusion_fuel", "#c:gasoline", "#c:glycerin", "#c:herbicide", "#c:heavy_water", "#c:hydrofluoric_acid", "#c:kerosene", "#c:latex", "#c:lithium", "#c:lpg", "#c:lubricant", "#c:meat", "#c:methanol", "#c:napalm", "#c:naphtha", "#c:oil", "#c:petrol", "#c:petroleum", "#c:phenolic_resin", "#c:plantoil", "#c:polluted_water", "#c:redstone_acid", "#c:sewage", "#c:sludge", "#c:sulfur_dioxide", "#c:sulfur_trioxide", "#c:sulfuric_acid", "#c:superheated_sodium", "#c:tritium", "#c:uranium_hexafluoride", "#c:uranium_oxide", "#beyond_earth:vehicle_fuel"}, "List of polluting fluids\nId is a basic unit (block or item) identifier in <modId:unitName:meta> format.\nModId can be omitted for vanilla items. Meta can be omitted too if it equals 0.\nUnitName must be lowercase, words separated by '_', words order - from particular to general (example: black_iron_ore).\nUse '*' char or '[]' as meta value to specify all possible values (all block states).\nTo define multiple block states, you can use block properties. The format is <modId:blockName:[prop1=value1, prop2=value2]>\nAlso you may use tags. The format is <#modId:tagPath> (example: #c:ores/copper).\n");
        this.impacts = new FluidImpactList(config, this.getHeadCategory(), "impacts", new String[]{"minecraft:dirt_path:* -> minecraft:podzol", "minecraft:dirt:* -> minecraft:coarse_dirt", "minecraft:farmland:* -> minecraft:podzol", "minecraft:grass_block:* -> minecraft:podzol", "minecraft:rooted_dirt:* -> minecraft:coarse_dirt", "minecraft:stone -> minecraft:cobblestone", "minecraft:bamboo:* -> KILL", "minecraft:cactus:* -> KILL", "#minecraft:crops -> KILL", "minecraft:fern:* -> KILL", "minecraft:grass:* -> KILL", "minecraft:large_fern:* -> KILL", "#minecraft:leaves -> KILL", "#minecraft:saplings -> KILL", "#minecraft:small_flowers -> KILL", "minecraft:tall_grass:* -> KILL", "#minecraft:tall_flowers -> KILL", "minecraft:tube_coral -> minecraft:dead_tube_coral", "minecraft:tube_coral_fan -> minecraft:dead_tube_coral_fan", "minecraft:brain_coral -> minecraft:dead_brain_coral", "minecraft:brain_coral_fan -> minecraft:dead_brain_coral_fan", "minecraft:bubble_coral -> minecraft:dead_bubble_coral", "minecraft:bubble_coral_fan -> minecraft:dead_bubble_coral_fan", "minecraft:fire_coral -> minecraft:dead_fire_coral", "minecraft:fire_coral_fan -> minecraft:dead_fire_coral_fan", "minecraft:horn_coral -> minecraft:dead_horn_coral", "minecraft:horn_coral_fan -> minecraft:dead_horn_coral_fan", "minecraft:big_dripleaf:* -> KILL", "minecraft:kelp:* -> KILL", "minecraft:kelp_plant:* -> KILL", "minecraft:lily_pad:* -> KILL", "minecraft:seagrass:* -> KILL", "minecraft:sea_pickle:* -> KILL", "minecraft:small_dripleaf:* -> KILL", "minecraft:tall_seagrass:* -> KILL", "minecraft:water -> POLLUTE", "ad_astra:oil:* -> water -> water", "beyond_earth:oil:* -> water -> water"});
    }

    public boolean doImpacts(FluidState fluid, ServerLevel level, BlockPos startPos) {
        if (!this.contains(fluid)) {
            return false;
        }
        if (this.tryGettingConsumedByUnderlyingWaterPlant(fluid, level, startPos)) {
            return true;
        }
        if (this.tryAffectSurroundings(fluid, level, startPos)) {
            return true;
        }
        if (this.canAffectUnderwaterBlocks && this.tryAffectUnderwaterBlock(fluid, level, startPos)) {
            return true;
        }
        return this.canSpreadAcrossWater && this.tryMoveAround(fluid, level, startPos);
    }

    protected boolean tryAffectBlock(FluidState fluid, ServerLevel level, BlockPos pos) {
        BlockState targetBlock = level.getBlockState(pos);
        BlockImpactList.AbstractAction action = this.getAction(fluid, targetBlock).orElse(null);
        if (action != null) {
            if (action.type == BlockImpactList.ActionType.POLLUTE) {
                Block fluidBlock = fluid.createLegacyBlock().getBlock();
                if (fluid.isSource() && fluidBlock instanceof PollutedWater) {
                    return false;
                }
            }
            return action.perform(level, pos, targetBlock);
        }
        return false;
    }

    protected boolean tryAffectUnderwaterBlock(FluidState fluid, ServerLevel level, BlockPos pos) {
        int distance;
        BlockPos startPos = pos.below();
        for (distance = 0; distance < this.maxUnderwaterDistance && this.isLiquidWaterBlock((ServerLevelAccessor)level, startPos.below(distance)); ++distance) {
        }
        if (distance > 0) {
            return this.tryAffectBlock(fluid, level, startPos.below(distance));
        }
        return false;
    }

    protected boolean isLiquidWaterBlock(ServerLevelAccessor level, BlockPos pos) {
        BlockState state = level.getBlockState(pos);
        return state.getBlock() instanceof LiquidBlock && state.getFluidState().is(FluidTags.WATER);
    }

    protected int getPressureAt(ServerLevel level, BlockPos pos) {
        Block validBlock = level.getBlockState(pos).getBlock();
        int pressure = 0;
        int distance = 1;
        while (pressure < this.maxWaterColumnPressure && level.getBlockState(pos.above(distance)).is(validBlock)) {
            ++pressure;
            ++distance;
        }
        return pressure;
    }

    protected boolean tryAffectSurroundings(final FluidState fluid, ServerLevel level, BlockPos startPos) {
        int pressure;
        if (this.canSpreadThroughSoil && (pressure = this.getPressureAt(level, startPos)) > 1) {
            int length = pressure + 2 + 1;
            SoilChain chain = new SoilChain((Level)level, startPos, length, startPos.above(pressure)){

                protected boolean isValidBlock(BlockPos pos) {
                    if (pos.getY() > this.top.getY()) {
                        return false;
                    }
                    BlockState block = this.level.getBlockState(pos);
                    return FluidImpacts.this.getAction(fluid, block).isPresent();
                }

                protected boolean onValidFound(BlockPos pos) {
                    this.affected = FluidImpacts.this.tryAffectBlock(fluid, (ServerLevel)this.level, pos);
                    return false;
                }
            };
            chain.build();
            return chain.isAffected();
        }
        for (Direction direction : GameWorld.Directions.of().all().shuffle().toList()) {
            BlockPos pos = startPos.relative(direction);
            if (!GameWorld.isBlockLoaded((LevelReader)level, (BlockPos)pos) || !this.tryAffectBlock(fluid, level, pos)) continue;
            return true;
        }
        return false;
    }

    protected boolean tryGettingConsumedByUnderlyingWaterPlant(FluidState fluid, ServerLevel level, BlockPos startPos) {
        BlockPos pos;
        if (PollutedWater.isSource((BlockGetter)level, startPos) && GameWorld.isWaterSource((LevelReader)level, (BlockPos)(pos = startPos.below())) && level.getBlockState(pos).getBlock() instanceof BonemealableBlock) {
            return level.removeBlock(pos, false) && level.setBlockAndUpdate(startPos, Blocks.WATER.defaultBlockState());
        }
        return false;
    }

    protected boolean tryMoveAround(FluidState fluid, ServerLevel level, BlockPos startPos) {
        if (!PollutedWater.isSource((BlockGetter)level, startPos)) {
            return false;
        }
        List directions = GameWorld.Directions.of().horizontals().shuffle().toList();
        GameWorld.getWindAt((Level)level, (BlockPos)startPos).sortDirections(directions);
        for (Direction direction : directions) {
            BlockState target;
            BlockState source;
            BlockPos pos = startPos.relative(direction);
            if (!GameWorld.isBlockLoaded((LevelReader)level, (BlockPos)pos) || !this.isLiquidWaterBlock((ServerLevelAccessor)level, pos) || !GameWorld.isWaterSource((LevelReader)level, (BlockPos)pos) || (source = level.getBlockState(startPos)) == (target = level.getBlockState(pos))) continue;
            return level.setBlockAndUpdate(startPos, target) && level.setBlockAndUpdate(pos, source);
        }
        return false;
    }

    public boolean contains(FluidState fluid) {
        if (fluid.isEmpty() || fluid.is((Fluid)Fluids.WATER) || fluid.is((Fluid)Fluids.FLOWING_WATER)) {
            return false;
        }
        return this.fluids.contains(fluid) || this.impacts.contains(fluid);
    }

    public Optional<BlockPos> findPollutingFluidInWaterAtPosOrAbove(ServerLevelAccessor level, BlockPos startPos) {
        for (int distance = 0; distance < this.maxUnderwaterDistance; ++distance) {
            BlockPos pos = startPos.above(distance);
            FluidState fluid = level.getFluidState(pos);
            if (this.contains(fluid)) {
                return Optional.of(pos);
            }
            if (!this.isLiquidWaterBlock(level, pos)) break;
        }
        return Optional.empty();
    }

    public Optional<BlockImpactList.AbstractAction> getAction(FluidState fluid, BlockState block) {
        Optional<BlockImpactList.AbstractAction> action = this.impacts.getActionFor(fluid, block);
        if (action.isPresent()) {
            return action;
        }
        return this.impacts.getCommonAction(block);
    }

    @Override
    protected String getHeadCategory() {
        return "FluidImpacts";
    }

    public List<String> getAllFluids() {
        ArrayList<String> list = new ArrayList<String>();
        this.fluids.listFluids(list);
        this.impacts.listFluids(list);
        return list;
    }

    public void onPostInit() {
        this.canSpreadAcrossWater = UnitConfig.getBool((UnitConfig)this.getConfig(), (String)this.getHeadCategory(), (String)"canSpreadAcrossWater", (boolean)true, (String)"Allows polluted water to spread out across the water driven by the wind");
        this.canSpreadThroughSoil = UnitConfig.getBool((UnitConfig)this.getConfig(), (String)this.getHeadCategory(), (String)"canSpreadThroughSoil", (boolean)true, (String)"Allows polluting fluids to spread through soil/sand blocks");
        this.canAffectUnderwaterBlocks = UnitConfig.getBool((UnitConfig)this.getConfig(), (String)this.getHeadCategory(), (String)"canAffectUnderwaterBlocks", (boolean)true, (String)"Allows polluting fluids floating on the water surface to affect underwater plants and blocks");
        this.maxWaterColumnPressure = UnitConfig.getInt((UnitConfig)this.getConfig(), (String)this.getHeadCategory(), (String)"maxWaterColumnPressure", (int)32, (IntBounds)IntBounds.between((Integer)0, (Integer)256), (String)"Limits the ability of polluting fluids to spread through soil blocks.\nNote that higher values may affect game performance.");
        this.maxUnderwaterDistance = UnitConfig.getInt((UnitConfig)this.getConfig(), (String)this.getHeadCategory(), (String)"maxUnderwaterDistance", (int)96, (IntBounds)IntBounds.between((Integer)0, (Integer)1024), (String)"Limits the distance at which polluting fluids can affect underwater blocks");
        this.fluids.loadData();
        this.impacts.loadData();
        this.saveConfig();
    }
}

