/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.items;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.client.Tooltip;
import com.endertech.minecraft.forge.client.renderer.ClientItemExtensions;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.items.GlassMeter;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.endertech.minecraft.mods.adpother.renderers.AerometerRenderer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class Aerometer
extends GlassMeter {
    public static final float THICKNESS = 0.08f;
    private CommonTime.Stamp lastCleaning;

    public Aerometer(UnitConfig config, GlassMeter.Properties<?> props) {
        super(config, props);
    }

    public static Optional<Entity> getCarrierFor(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof Aerometer) {
            Aerometer meter = (Aerometer)item;
            return Optional.ofNullable((Entity)meter.carriers.get(stack));
        }
        return Optional.empty();
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept((IClientItemExtensions)ClientItemExtensions.of(AerometerRenderer::new));
    }

    public static List<ItemStack> findInInventoryOf(Player player) {
        ArrayList<ItemStack> found = new ArrayList<ItemStack>();
        Inventory inventory = player.getInventory();
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            ItemStack stack = inventory.getItem(i);
            if (!(stack.getItem() instanceof Aerometer)) continue;
            found.add(stack);
        }
        return found;
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        this.updateCarrier(stack, entity);
    }

    public void updateCarrier(ItemStack stack, Entity entity) {
        if (ForgeEntity.isClientSide((Entity)entity)) {
            this.carriers.put(stack, entity);
            if (this.lastCleaning == null || CommonTime.Interval.passedFrom((CommonTime.Stamp)this.lastCleaning).moreThan(CommonTime.Interval.seconds((double)10.0))) {
                this.cleanUselessStacks();
                this.lastCleaning = CommonTime.Stamp.now();
            }
        }
    }

    public boolean onEntityItemUpdate(ItemStack stack, ItemEntity entity) {
        this.updateCarrier(stack, (Entity)entity);
        return false;
    }

    private void cleanUselessStacks() {
        Iterator iterator = this.carriers.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ItemStack stack = (ItemStack)entry.getKey();
            Entity entity = (Entity)entry.getValue();
            if (!stack.isEmpty() && ForgeEntity.hasStack((Entity)entity, (ItemStack)stack)) continue;
            iterator.remove();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
        Optional<Entity> carrier;
        if (Aerometer.notBroken((ItemStack)stack) && (carrier = Aerometer.getCarrierFor(stack)).isPresent()) {
            Tooltip tip = Tooltip.of((AbstractForgeMod)AdPother.getInstance(), (String)"aerometer", lines);
            EntityPollution pollution = WorldData.getEntityPollution(carrier.get());
            pollution.getInfos().map(info -> info.getPollutant()).forEach(pollutant -> tip.addRaw(String.valueOf(pollutant.getTextColor()) + pollutant.getName().getString() + ": " + pollution.getInfluenceOf((Pollutant<?>)((Object)pollutant)).toColoredText()));
        }
        super.appendHoverText(stack, context, lines, flag);
    }
}

