/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.items;

import com.endertech.common.CommonMath;
import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.items.EquipmentItem;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.forge.math.Percentage;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.entities.GasEntity;
import com.endertech.minecraft.mods.adpother.pollution.IStorage;
import com.endertech.minecraft.mods.adpother.pollution.IStorageItem;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class VacuumBag
extends EquipmentItem
implements IStorageItem {
    private final int capacity;

    public VacuumBag(UnitConfig config, Properties<?> props) {
        super(config, props);
        this.capacity = UnitConfig.getInt((UnitConfig)config, (String)props.name, (String)"capacity", (int)props.capacity, (IntBounds)IntBounds.INTEGER_POSITIVE, (String)"Defines the maximum capacity of the bag.");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> lines, TooltipFlag flag) {
        IStorageItem.super.appendHoverText(stack, context, lines, flag);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        GasEntity carrier;
        Optional state;
        Level level = entity.level();
        if (GameWorld.isServerSide((LevelReader)level) && entity instanceof GasEntity && (state = (carrier = (GasEntity)entity).getCarriedBlockState()).isPresent() && carrier.spend()) {
            Block.dropResources((BlockState)((BlockState)state.get()), (Level)level, (BlockPos)carrier.blockPosition());
        }
        return super.onLeftClickEntity(stack, player, entity);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.getBlock() instanceof Pollutant;
    }

    @Override
    public int fill(ItemStack storage, Pollutant<?> pollutant, int amount) {
        if (VacuumBag.isBroken((ItemStack)storage)) {
            return 0;
        }
        IStorage.Content content = this.getContent(storage);
        float gradeFactor = content.getFullnessPercentageFor(pollutant).getGrade().ordinal() + 1;
        float wearoutChance = 0.05f * gradeFactor;
        if (CommonMath.Random.result((float)wearoutChance)) {
            ForgeItem.hurtNotDestroy((ItemStack)storage, (int)1, null, null, item -> {});
        }
        Percentage wearout = this.getWearoutPercentage(storage);
        boolean leak = false;
        if (wearout.getGrade() == Percentage.Grade.HIGH) {
            float chance = Percentage.HUNDRED.getValue() - wearout.getGrade().threshold;
            float probability = 1.0f / Math.max(1.0f, chance);
            leak = CommonMath.Random.result((float)probability);
        }
        if (leak) {
            return 0;
        }
        return IStorageItem.super.fill(storage, pollutant, amount);
    }

    @Override
    public int getInitialCapacity(ItemStack storage) {
        return this.capacity;
    }

    public static class Properties<T extends Properties<T>>
    extends EquipmentItem.Properties<T> {
        public int capacity;

        public static Properties<?> of(String name) {
            return new Properties<Properties>(Properties.class, name);
        }

        protected Properties(Class<T> selfClass, String name) {
            super(selfClass, name);
        }

        public T capacity(int capacity) {
            this.capacity = capacity;
            return (T)((Object)((Properties)this.self));
        }
    }
}

