/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.mixin;

import com.endertech.common.CommonCollect;
import com.endertech.common.CommonMath;
import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.entities.ForgeEffect;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.impacts.FluidImpacts;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BottleItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={BottleItem.class})
public abstract class BottleItemMixin
extends Item {
    public BottleItemMixin(Item.Properties pProperties) {
        super(pProperties);
    }

    @Redirect(method={"use"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/alchemy/PotionContents;createItemStack(Lnet/minecraft/world/item/Item;Lnet/minecraft/core/Holder;)Lnet/minecraft/world/item/ItemStack;"))
    private ItemStack createItemStack(Item item, Holder<Potion> potion, Level level, Player player, InteractionHand hand) {
        BlockHitResult hit = BottleItemMixin.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (hit.getType() == HitResult.Type.BLOCK) {
            FluidState fluid = level.getFluidState(hit.getBlockPos());
            if (((FluidImpacts)AdPother.getInstance().impacts.fluidImpacts.get()).contains(fluid)) {
                return this.makePoisonousPotion(item, potion);
            }
        }
        return PotionContents.createItemStack((Item)item, potion);
    }

    private ItemStack makePoisonousPotion(Item item, Holder<Potion> potion) {
        List<MobEffectInstance> allEffects = Stream.of(this.makeEffect((Holder<MobEffect>)MobEffects.POISON, 5, 15), this.makeEffect((Holder<MobEffect>)MobEffects.BLINDNESS, 5, 15), this.makeEffect((Holder<MobEffect>)MobEffects.DIG_SLOWDOWN, 30, 300), this.makeEffect((Holder<MobEffect>)MobEffects.HARM, 1, 1), this.makeEffect((Holder<MobEffect>)MobEffects.MOVEMENT_SLOWDOWN, 30, 300), this.makeEffect((Holder<MobEffect>)MobEffects.WEAKNESS, 30, 300), this.makeEffect((Holder<MobEffect>)MobEffects.HUNGER, 30, 300), this.makeEffect((Holder<MobEffect>)MobEffects.CONFUSION, 5, 15)).toList();
        HashSet pickedEffects = new HashSet();
        int maxEffects = CommonMath.Random.between((int)1, (int)allEffects.size());
        for (int i = 0; i < maxEffects; ++i) {
            CommonCollect.getRandomElementFrom(allEffects).ifPresent(pickedEffects::add);
        }
        PotionContents contents = new PotionContents(Optional.of(potion), Optional.empty(), pickedEffects.stream().toList());
        ItemStack stack = new ItemStack((ItemLike)item);
        stack.set(DataComponents.POTION_CONTENTS, (Object)contents);
        return stack;
    }

    private MobEffectInstance makeEffect(Holder<MobEffect> effect, int minDuration, int maxDuration) {
        CommonTime.Interval duration = CommonTime.Interval.seconds((double)CommonMath.Random.between((int)minDuration, (int)maxDuration));
        return ForgeEffect.createInstance(effect, (CommonTime.Interval)duration, (boolean)true);
    }
}

