/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.mixin;

import com.endertech.minecraft.mods.adpother.compat.McwWindows;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Pseudo
@Mixin(targets={"com.mcwwindows.kikoz.objects.WindowBarred"})
public abstract class WindowBarredMixin
extends Block {
    public WindowBarredMixin(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    protected void randomTick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        McwWindows.getInstance().ifPresent(windows -> windows.tryDrawGasOut(level, pos, state, false));
    }

    @Inject(method={"useWithoutItem"}, at={@At(value="HEAD")})
    protected void useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hit, CallbackInfoReturnable<InteractionResult> callback) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            McwWindows.getInstance().ifPresent(windows -> windows.tryDrawGasOut(serverLevel, pos, state, true));
        }
    }
}

