/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.renderers;

import com.endertech.minecraft.forge.client.renderer.ChestWearItemLayer;
import com.endertech.minecraft.forge.compat.CuriosAPI;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.mods.adpother.items.VacuumBag;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VacuumBagLayer<L extends LivingEntity, M extends HumanoidModel<L>>
extends ChestWearItemLayer<L, M> {
    public VacuumBagLayer(RenderLayerParent<L, M> entityRenderer) {
        super(entityRenderer);
    }

    public boolean shouldRender(ItemStack stack, L living) {
        Item item = stack.getItem();
        if (item instanceof VacuumBag) {
            VacuumBag bag = (VacuumBag)item;
            if (living.getItemBySlot(EquipmentSlot.CHEST).is((Item)bag)) {
                return true;
            }
            return CuriosAPI.getInstance().map(api -> api.findCurios(living, (Item)bag, true)).map(list -> !list.isEmpty()).orElse(false);
        }
        return false;
    }

    public ItemStack getWearItem(L livingEntity) {
        for (ItemStack stack : ForgeEntity.getEquipmentOn(livingEntity)) {
            if (!(stack.getItem() instanceof VacuumBag)) continue;
            return stack;
        }
        return ItemStack.EMPTY;
    }
}

