/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.sources;

import com.endertech.common.CommonTime;
import com.endertech.minecraft.forge.data.INBTSource;
import com.endertech.minecraft.forge.entities.ForgeEntity;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.mods.adpother.emissions.AbstractEntityEmission;
import com.endertech.minecraft.mods.adpother.pollution.GasExplosion;
import com.endertech.minecraft.mods.adpother.sources.Torch;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ModConfigSpec;

public class DroppedTorch
extends AbstractEntityEmission<ItemEntity, Torch> {
    public static ModConfigSpec.ConfigValue<Double> rate;
    protected final CommonTime.Stamp creationTime = CommonTime.Stamp.now();
    protected final CommonTime.Interval lifeSpan;

    protected DroppedTorch(ItemEntity entity, Torch emitter, GameTime updateInterval, CommonTime.Interval lifeSpan) {
        super(entity, emitter, updateInterval);
        this.lifeSpan = lifeSpan;
    }

    public static DroppedTorch of(ItemEntity entity, Torch torch) {
        return new DroppedTorch(entity, torch, GameTime.second(), CommonTime.Interval.minutes((double)5.0));
    }

    public Level getWorldLevel() {
        return ((ItemEntity)this.entity).level();
    }

    public boolean isEntityDeadOrRemoved() {
        Entity entity = (Entity)this.getEntity();
        if (!entity.isAlive()) {
            return true;
        }
        return !entity.isAddedToLevel();
    }

    @Override
    public BlockPos getEntityBlockPos() {
        return ForgeEntity.getCenterPosition((Entity)((Entity)this.getEntity())).toBlockPos();
    }

    public void onUpdate() {
        if (CommonTime.Interval.passedFrom((CommonTime.Stamp)this.creationTime).moreThan(this.lifeSpan)) {
            this.kill();
            return;
        }
        if (this.isEntityDeadOrRemoved()) {
            this.kill();
            return;
        }
        if (!this.isInEntityTickingChunk()) {
            return;
        }
        Level world = this.getWorldLevel();
        if (world == null) {
            return;
        }
        BlockPos pos = this.getEntityBlockPos();
        if (GasExplosion.in(world).position(pos).tryExplode()) {
            this.kill();
            return;
        }
        Torch torch = (Torch)((Object)this.getEmitter());
        if (torch.isActive(INBTSource.of((Entity)((Entity)this.getEntity())))) {
            torch.emitAt(world, pos, ((Double)rate.get()).floatValue());
        }
    }
}

