/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.IBounds;
import com.endertech.common.IntBounds;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.phys.AABB;

public class WorldBounds {
    private final IntBounds x;
    private final IntBounds y;
    private final IntBounds z;

    public static WorldBounds from(IntBounds x, IntBounds y, IntBounds z) {
        return new WorldBounds(x, y, z);
    }

    public static WorldBounds from(BlockPos pos, int radius) {
        return WorldBounds.from(IntBounds.of(pos.getX()), IntBounds.of(pos.getY()), IntBounds.of(pos.getZ())).extend(radius);
    }

    public static WorldBounds from(BlockPos pos1, BlockPos pos2) {
        return WorldBounds.from(IntBounds.between(pos1.getX(), pos2.getX()), IntBounds.between(pos1.getY(), pos2.getY()), IntBounds.between(pos1.getZ(), pos2.getZ()));
    }

    public static WorldBounds chunksAround(LevelHeightAccessor level, ChunkPos center) {
        ChunkPos min = new ChunkPos(center.x - 1, center.z - 1);
        ChunkPos max = new ChunkPos(center.x + 1, center.z + 1);
        return WorldBounds.from(IntBounds.between(min.getMinBlockX(), max.getMaxBlockX()), WorldBounds.getHeightBounds(level), IntBounds.between(min.getMinBlockZ(), max.getMaxBlockZ()));
    }

    public static IntBounds getHeightBounds(LevelHeightAccessor level) {
        return IntBounds.between(level.getMinBuildHeight(), level.getMaxBuildHeight() - 1);
    }

    public static WorldBounds vertPlane(BlockPos centerPos, int radius, Direction normal) {
        if (normal.getAxis().isVertical()) {
            return WorldBounds.from(centerPos, centerPos);
        }
        Direction facing = normal.getClockWise();
        BlockPos from = new BlockPos((Vec3i)centerPos.relative(facing, -radius).below(radius));
        BlockPos to = new BlockPos((Vec3i)centerPos.relative(facing, radius).above(radius));
        WorldBounds bounds = WorldBounds.from(from, to);
        return bounds;
    }

    public static WorldBounds horizPlane(BlockPos center, int radius) {
        return WorldBounds.from(center.offset(-radius, 0, -radius), center.offset(radius, 0, radius));
    }

    protected WorldBounds(IntBounds x, IntBounds y, IntBounds z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public IntBounds getX() {
        return this.x;
    }

    public IntBounds getZ() {
        return this.z;
    }

    public IntBounds getY() {
        return this.y;
    }

    public int getHeight() {
        return this.getY().length() + 1;
    }

    public boolean encloses(BlockPos pos) {
        return this.getX().encloses(pos.getX()) && this.getY().encloses(pos.getY()) && this.getZ().encloses(pos.getZ());
    }

    public boolean within(WorldBounds bounds) {
        return this.getX().within(bounds.getX()) && this.getY().within(bounds.getY()) && this.getZ().within(bounds.getZ());
    }

    public WorldBounds offset(int x, int y, int z) {
        return WorldBounds.from(this.getX().offset(x), this.getY().offset(y), this.getZ().offset(z));
    }

    public WorldBounds extend(int x, int y, int z) {
        return WorldBounds.from(this.getX().extend(x), this.getY().extend(y), this.getZ().extend(z));
    }

    public WorldBounds extend(int value) {
        return this.extend(value, value, value);
    }

    public WorldBounds extend(Direction facing, int value) {
        IBounds x = this.getX().offset(facing.getStepX() * value).unite((IBounds)this.getX());
        IBounds y = this.getY().offset(facing.getStepY() * value).unite((IBounds)this.getY());
        IBounds z = this.getZ().offset(facing.getStepZ() * value).unite((IBounds)this.getZ());
        return WorldBounds.from((IntBounds)x, (IntBounds)y, (IntBounds)z);
    }

    public WorldBounds reduce(int x, int y, int z) {
        return WorldBounds.from(this.getX().reduce(x), this.getY().reduce(y), this.getZ().reduce(z));
    }

    public WorldBounds reduce(int value) {
        return this.reduce(value, value, value);
    }

    public BlockPos relative(BlockPos pos) {
        BlockPos min = this.min();
        return new BlockPos(pos.getX() - min.getX(), pos.getY() - min.getY(), pos.getZ() - min.getZ());
    }

    public boolean face(BlockPos pos) {
        return this.getX().corners(pos.getX()) || this.getY().corners(pos.getY()) || this.getZ().corners(pos.getZ());
    }

    public boolean edge(BlockPos pos) {
        int result = 0;
        if (this.getX().corners(pos.getX())) {
            ++result;
        }
        if (this.getY().corners(pos.getY())) {
            ++result;
        }
        if (this.getZ().corners(pos.getZ())) {
            ++result;
        }
        return result >= 2;
    }

    public boolean vertex(BlockPos pos) {
        return this.getX().corners(pos.getX()) && this.getY().corners(pos.getY()) && this.getZ().corners(pos.getZ());
    }

    public void forEach(Consumer<? super BlockPos.MutableBlockPos> action) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x : this.getX()) {
            for (int y : this.getY()) {
                for (int z : this.getZ()) {
                    pos.set(x, y, z);
                    action.accept((BlockPos.MutableBlockPos)pos);
                }
            }
        }
    }

    public BlockPos min() {
        return new BlockPos(this.getX().getMin().intValue(), this.getY().getMin().intValue(), this.getZ().getMin().intValue());
    }

    public BlockPos max() {
        return new BlockPos(this.getX().getMax().intValue(), this.getY().getMax().intValue(), this.getZ().getMax().intValue());
    }

    public BlockPos randomPos(Random random) {
        return new BlockPos(this.getX().randomBetween(random).intValue(), this.getY().randomBetween(random).intValue(), this.getZ().randomBetween(random).intValue());
    }

    public AABB toAABB() {
        return new AABB((double)this.min().getX(), (double)this.min().getY(), (double)this.min().getZ(), (double)this.max().getX(), (double)this.max().getY(), (double)this.max().getZ());
    }
}

