function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'blusunrize/immersiveengineering/common/blocks/multiblocks/logic/DieselGeneratorLogic',
		'methodName' : 'tickServer',
		'methodDesc' : '(Lblusunrize/immersiveengineering/api/multiblocks/blocks/env/IMultiblockContext;)V'
	}

	var node = {
		'class' : 'net/neoforged/neoforge/fluids/capability/templates/FluidTank',
		'methodName' : 'drain',
		'methodDesc' : '(ILnet/neoforged/neoforge/fluids/capability/IFluidHandler$FluidAction;)Lnet/neoforged/neoforge/fluids/FluidStack;'
	}

	var level = {
    	'class' : 'blusunrize/immersiveengineering/api/multiblocks/blocks/env/IMultiblockContext',
    	'methodName' : 'getLevel',
    	'methodDesc' : '()Lblusunrize/immersiveengineering/api/multiblocks/blocks/env/IMultiblockLevel;'
    }

	var generator = {
		'class': 'blusunrize/immersiveengineering/common/blocks/multiblocks/IEMultiblocks',
		'fieldName': 'DIESEL_GENERATOR',
		'fieldDesc': 'Lblusunrize/immersiveengineering/common/blocks/multiblocks/IETemplateMultiblock;'
	}

	var offset = {
    	'class' : 'blusunrize/immersiveengineering/common/blocks/multiblocks/IETemplateMultiblock',
    	'methodName' : 'getMasterFromOriginOffset',
    	'methodDesc' : '()Lnet/minecraft/core/BlockPos;'
    }

	var entity = {
    	'class' : 'blusunrize/immersiveengineering/api/multiblocks/blocks/env/IMultiblockLevel',
    	'methodName' : 'getBlockEntity',
    	'methodDesc' : '(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/entity/BlockEntity;'
    }

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/neoforged/neoforge/fluids/FluidStack;Lnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [ 
		insnDup("fluidstack"),
		insnLoadObj(1, "context"),
        insnInvokeInterface(level),
        insnGetStatic(generator),
        insnInvokeVirtual(offset),
        insnInvokeInterface(entity),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsAfter(method, node, instructions);
				return method;
			}
		}
	}
}