function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'blusunrize/immersiveengineering/common/blocks/multiblocks/logic/FurnaceHandler',
		'methodName' : 'tickServer',
		'methodDesc' : '(Lblusunrize/immersiveengineering/api/multiblocks/blocks/env/IMultiblockContext;)Z'
	}

	var node = {
   		'class' : 'net/minecraft/world/item/ItemStack',
   		'methodName' : 'shrink',
   		'methodDesc' : '(I)V'
   	}

	var level = {
    	'class' : 'blusunrize/immersiveengineering/api/multiblocks/blocks/env/IMultiblockContext',
    	'methodName' : 'getLevel',
    	'methodDesc' : '()Lblusunrize/immersiveengineering/api/multiblocks/blocks/env/IMultiblockLevel;'
    }

	var offset = {
		'class': 'blusunrize/immersiveengineering/common/blocks/multiblocks/logic/CokeOvenLogic',
		'fieldName': 'MASTER_OFFSET',
		'fieldDesc': 'Lnet/minecraft/core/BlockPos;'
	}

	var entity = {
    	'class' : 'blusunrize/immersiveengineering/api/multiblocks/blocks/env/IMultiblockLevel',
    	'methodName' : 'getBlockEntity',
    	'methodDesc' : '(Lnet/minecraft/core/BlockPos;)Lnet/minecraft/world/level/block/entity/BlockEntity;'
    }

	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFurnaceFuelBurned',
		'methodDesc' : '(Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [
        insnDup2("stack, count"),
		insnLoadObj(1, "context"),
        insnInvokeInterface(level),
        insnGetStatic(offset),
        insnInvokeInterface(entity),
    	insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBefore(method, node, instructions);
				return method;
			}
		}
	}
}