function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'flaxbeard/immersivepetroleum/common/blocks/tileentities/GasGeneratorTileEntity',
		'methodName' : 'tick',
		'methodDesc' : '()V'
	}

	var node = {
		'class' : 'net/minecraftforge/fluids/capability/templates/FluidTank',
		'methodName' : 'drain',
		'methodDesc' : '(Lnet/minecraftforge/fluids/FluidStack;Lnet/minecraftforge/fluids/capability/IFluidHandler$FluidAction;)Lnet/minecraftforge/fluids/FluidStack;'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/minecraftforge/fluids/FluidStack;Lnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [ 
		insnDup("consumed fuel"),
		insnLoadThis("gas generator tile"), 
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructions(method, node, instructions, false);
				return method;
			}
		}
	}
}