function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile(
			'coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'cam72cam/immersiverailroading/entity/LocomotiveDiesel',
		'methodName' : 'onTick',
		'methodDesc' : '()V'
	}

	var node = {
		'class' : 'cam72cam/mod/fluid/FluidTank',
		'methodName' : 'drain',
		'methodDesc' : '(Lcam72cam/mod/fluid/FluidStack;Z)Lcam72cam/mod/fluid/FluidStack;'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/minecraftforge/fluids/FluidStack;Lnet/minecraft/entity/Entity;Lcom/endertech/minecraft/mods/adpother/events/WorldEvents$Alignment;)V'
	}

	var internalStack = {
		'class' : 'cam72cam/mod/fluid/FluidStack',
		'fieldName' : 'internal',
		'fieldDesc' : 'Lnet/minecraftforge/fluids/FluidStack;'
	}

	var internalEntity = {
		'class' : 'cam72cam/immersiverailroading/entity/LocomotiveDiesel',
		'fieldName' : 'internal',
		'fieldDesc' : 'Lcam72cam/mod/entity/ModdedEntity;'
	}

	var alignment = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents$Alignment',
		'fieldName' : 'CENTER',
		'fieldDesc' : 'Lcom/endertech/minecraft/mods/adpother/events/WorldEvents$Alignment;'
	}

	var instructions = [ 
		insnDup("fuel fluidstack"),
		insnGetField(internalStack),
		insnLoadThis("diesel locomotive"),
		insnGetField(internalEntity),
		insnGetStatic(alignment), 
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsAfter(method, node, instructions);
				return method;
			}
		}
	}
}