function initializeCoreMod() {
	Java.type('net.neoforged.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'com/buuz135/industrial/block/generator/tile/BiofuelGeneratorTile',
		'methodName' : 'consumeFuel',   
		'methodDesc' : '()I'
	}

	var node = {
		'class' : 'com/hrznstudio/titanium/component/fluid/SidedFluidTankComponent',
		'methodName' : 'drainForced',
		'methodDesc' : '(ILnet/minecraftforge/fluids/capability/IFluidHandler$FluidAction;)Lnet/minecraftforge/fluids/FluidStack;'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFuelBurned',
		'methodDesc' : '(Lnet/minecraftforge/fluids/FluidStack;Lnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [ 
		insnDup("consumed fuel fluidstack"),
		insnLoadThis("biofuel generator tile"), 
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsAfter(method, node, instructions);
				return method;
			}
		}
	}
}