/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.chains;

import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldSearch;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;

public abstract class WaterChain
extends WorldSearch.BlockChain {
    protected final int maxRadius;

    protected WaterChain(LevelAccessor world, BlockPos startPos, int maxRadius) {
        super(world, startPos, Math.round((float)Math.PI * (float)maxRadius * (float)maxRadius));
        this.maxRadius = maxRadius;
    }

    protected Collection<Direction> getDirections() {
        return GameWorld.Directions.of().horizontals().shuffle().toList();
    }

    protected boolean isWithinMaxRadius(BlockPos pos) {
        return this.startPos.m_123331_((Vec3i)pos) <= (double)(this.maxRadius * this.maxRadius);
    }

    protected boolean isValidPath(BlockPos pos) {
        if (this.lastUsedDirection == null) {
            return true;
        }
        if (!this.isWithinMaxRadius(pos)) {
            return false;
        }
        return GameWorld.isWaterBlock((LevelReader)this.level, (BlockPos)pos);
    }
}

