/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.util.INBTSerializable;

public class Caupona {

    public static class KitchenStove
    extends Emitter {
        protected final UnitId flue = UnitId.from((String)"#caupona:chimney");
        protected final UnitId pot = UnitId.from((String)"#caupona:chimney_pot");
        protected final UnitId ignore = UnitId.from((String)"#caupona:chimney_ignore");

        public KitchenStove(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
        }

        @Override
        public BlockPos getExhaustPosition(LevelAccessor level, INBTSerializable<CompoundTag> nbtSource, BlockPos defaultPos) {
            BlockState state;
            BlockPos pos = defaultPos.m_7494_();
            for (int i = 0; i < 2 && this.ignore.matches(state = level.m_8055_(pos)); ++i) {
                pos = pos.m_7494_();
            }
            boolean hasChimneyFlue = false;
            while (!level.m_151570_(pos) && this.flue.matches(state = level.m_8055_(pos))) {
                hasChimneyFlue = true;
                pos = pos.m_7494_();
            }
            if (hasChimneyFlue && GameWorld.SmokeContainers.hasWayOut((LevelReader)level, (BlockPos)pos) && this.hasAirAround(level, pos)) {
                return pos;
            }
            return defaultPos;
        }

        protected boolean hasAirAround(LevelAccessor level, BlockPos startPos) {
            for (Direction dir : GameWorld.Directions.of().all().remove(new Direction[]{Direction.DOWN}).toList()) {
                BlockPos pos = startPos.m_121945_(dir);
                if (!GameWorld.isBlockLoaded((LevelReader)level, (BlockPos)pos) || !GameWorld.isAirBlock((LevelReader)level, (BlockPos)pos)) continue;
                return true;
            }
            return false;
        }
    }
}

