/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.forge.world.WorldSearch;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.INBTSerializable;

public class ColdSweat {
    public static final String MOD_ID = "cold_sweat";
    static final UnitId SMOKESTACK = UnitId.from((String)"cold_sweat", (String)"smokestack").withMetaAll();

    public static Emitter.Properties<?> heater() {
        return Emitter.Properties.fuel("HotFuel/Amount", 6.756f).customFactory(Heater::new);
    }

    public static Emitter.Properties<?> boiler() {
        return ColdSweat.heater();
    }

    public static Emitter.Properties<?> hearth() {
        return ColdSweat.heater().id(UnitId.from((String)MOD_ID, (String)"hearth_bottom").withMetaAll()).relatedBlocks(UnitId.from((String)MOD_ID, (String)"hearth_top").withMetaAll().toString());
    }

    public static class Heater
    extends Emitter {
        protected final int maxSmokestackLength;

        public Heater(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
            this.maxSmokestackLength = UnitConfig.getInt((UnitConfig)config, (String)this.getClassCategory(), (String)"maxSmokestackLength", (int)128, (IntBounds)IntBounds.between((Integer)1, (Integer)1024), (String)"The maximum length of the connected smokestack.\nNote that high values affect performance");
        }

        @Override
        public BlockPos getExhaustPosition(LevelAccessor level, INBTSerializable<CompoundTag> nbtSource, BlockPos defaultPos) {
            if (nbtSource instanceof BlockEntity) {
                BlockEntity tile = (BlockEntity)nbtSource;
                WorldSearch.TileNeighbors neighbors = WorldSearch.TileNeighbors.from((BlockEntity)tile, this.getRelatedBlocks());
                for (BlockPos pos : neighbors.getAboveBlocks()) {
                    Optional<BlockPos> outlet;
                    BlockState state = level.m_8055_(pos);
                    if (!this.isPipeBendedOrFacing(Direction.UP, state) || !(outlet = this.getPipeOutlet(level, pos)).isPresent()) continue;
                    return outlet.get();
                }
            }
            return defaultPos;
        }

        protected boolean isPipe(BlockState state) {
            return SMOKESTACK.matches(state);
        }

        protected boolean isFacing(Direction direction, BlockState state) {
            return this.stateHasValue(state, "facing", direction.m_122433_());
        }

        protected boolean isBended(BlockState state) {
            return this.stateHasValue(state, "facing", "bend");
        }

        protected boolean isPipeBendedOrFacing(Direction direction, BlockState state) {
            return this.isPipe(state) && (this.isBended(state) || this.isFacing(direction, state) || this.isFacing(direction.m_122424_(), state));
        }

        protected boolean stateHasValue(BlockState state, String propertyName, String valueName) {
            Property property = state.m_60734_().m_49965_().m_61081_(propertyName);
            if (property != null && state.m_61138_(property)) {
                return property.m_6215_(valueName).filter(value -> value.equals(state.m_61143_(property))).isPresent();
            }
            return false;
        }

        protected Optional<BlockPos> getPipeOutlet(LevelAccessor level, BlockPos startPos) {
            WorldSearch.BlockChain pipe = new WorldSearch.BlockChain(level, startPos, this.maxSmokestackLength){

                protected Collection<Direction> getDirections() {
                    Direction[] horizontals = GameWorld.Directions.of().horizontals().shuffle().toArray();
                    return GameWorld.Directions.of().up().add(horizontals).down().toList();
                }

                private boolean isValidDirection(BlockPos pos) {
                    if (this.lastUsedDirection != null) {
                        BlockPos prevPos = pos.m_121945_(this.lastUsedDirection.m_122424_());
                        BlockState state = this.level.m_8055_(prevPos);
                        return this.isPipeBendedOrFacing(this.lastUsedDirection, state);
                    }
                    return false;
                }

                protected boolean isValidPath(BlockPos pos) {
                    BlockState state;
                    if (this.lastUsedDirection == null) {
                        return true;
                    }
                    return this.isValidDirection(pos) && this.isPipeBendedOrFacing(this.lastUsedDirection, state = this.level.m_8055_(pos));
                }

                protected boolean isValidBlock(BlockPos pos) {
                    if (this.isValidDirection(pos) && (this.level.m_46859_(pos) || GameWorld.SmokeContainers.isChimney((LevelReader)this.level, (BlockPos)pos))) {
                        Direction direction = this.lastUsedDirection;
                        BlockPos prevPos = pos.m_121945_(direction.m_122424_());
                        BlockState state = this.level.m_8055_(prevPos);
                        return this.isPipe(state) && (this.isFacing(direction, state) || this.isFacing(direction.m_122424_(), state));
                    }
                    return false;
                }

                protected boolean onValidFound(BlockPos pos) {
                    return false;
                }
            };
            pipe.build();
            return pipe.getFound().stream().findFirst();
        }
    }
}

