/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.common.IntBounds;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.forge.math.GameTime;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;

public class Corpse
extends Emitter {
    public final IntBounds ageBounds;

    public static Emitter.Properties<?> properties() {
        return (Emitter.Properties)((Object)((SourceBase.Properties)((Object)Emitter.Properties.entity("#hardcoded_age_check", WorldEvents.Alignment.TOP).customFactory(Corpse::new))).carbon(0.5f));
    }

    public Corpse(UnitConfig config, Emitter.Properties<?> props) {
        super(config, props);
        this.ageBounds = config.getIntBounds(this.getClassCategory(), "Age", IntBounds.between((Integer)10, (Integer)60), IntBounds.INTEGER_POSITIVE, "The corpse will produce pollution only when its age is within the specified range (in minutes)");
    }

    @Override
    public boolean isActive(INBTSerializable<CompoundTag> nbtSource) {
        if (nbtSource != null) {
            try {
                CompoundTag compound = TagHelper.serialize(nbtSource);
                int ageInTicks = compound.m_128451_("Age");
                int ageInMinutes = (int)GameTime.fromServerTicks((long)ageInTicks).inMinutes();
                return this.ageBounds.encloses(Integer.valueOf(ageInMinutes));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }
}

