/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.forge.world.GameWorld;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.LavaTouchingWater;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;

public class Create {
    public static final String MOD_ID = "create";
    public static ForgeConfigSpec.ConfigValue<Boolean> fanProcessingEmissions;
    private static final Lazy<Optional<Create>> INSTANCE;
    private final Class<?> allFanProcessingTypes = Class.forName("com.simibubi.create.content.kinetics.fan.processing.AllFanProcessingTypes");
    private final Object blastingType = this.allFanProcessingTypes.getField("BLASTING").get(null);
    private final Object smokingType = this.allFanProcessingTypes.getField("SMOKING").get(null);

    private Create() throws ClassNotFoundException, NoSuchFieldException, IllegalAccessException {
    }

    public boolean isCombustionFanProcessingType(Object processingType) {
        return processingType == this.blastingType || processingType == this.smokingType;
    }

    public static Optional<Create> getInstance() {
        return (Optional)INSTANCE.get();
    }

    public static final void handleFanProcessing(ItemEntity itemEntity, Object processingType) {
        if (((Boolean)fanProcessingEmissions.get()).booleanValue()) {
            Create.getInstance().filter(create -> create.isCombustionFanProcessingType(processingType)).ifPresent(create -> WorldEvents.onItemBurned(itemEntity.m_32055_(), itemEntity.m_9236_(), itemEntity.m_20183_()));
        }
    }

    public static final void handleAirCurrent(Level level, BlockPos pos, Direction direction, boolean pushing) {
        ServerLevel serverLevel;
        BlockState state;
        Block block;
        if (level instanceof ServerLevel && (block = (state = (serverLevel = (ServerLevel)level).m_8055_(pos)).m_60734_()) instanceof AbstractGas) {
            AbstractGas gas = (AbstractGas)block;
            gas.createSpread(serverLevel, pos, state).inDirectionForced(pushing ? direction : direction.m_122424_()).inDirectionsForced(() -> GameWorld.Directions.of().all().remove(new Direction[]{direction, direction.m_122424_()}).shuffle()).apply();
        }
    }

    public static final void handleFluidCollision(Level level, BlockPos pos, Fluid firstFluid, Fluid secondFluid) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (firstFluid.m_205067_(FluidTags.f_13132_) && (secondFluid == Fluids.f_76193_ || secondFluid == Fluids.f_76192_) || secondFluid.m_205067_(FluidTags.f_13132_) && (firstFluid == Fluids.f_76193_ || firstFluid == Fluids.f_76192_)) {
                ((LavaTouchingWater)((Object)AdPother.getInstance().sources.lavaTouchingWater.get())).emitAt((Level)serverLevel, pos);
            }
        }
    }

    public static Emitter.Properties<?> boiler() {
        UnitId boilerID = UnitId.from((String)MOD_ID, (String)"fluid_tank").withMetaAll();
        UnitId engineID = UnitId.from((String)MOD_ID, (String)"steam_engine").withMetaAll();
        return (Emitter.Properties)((Object)((Emitter.Properties)((Object)((SourceBase.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.tile("").id(boilerID).customFactory(Boiler::new))).relatedBlocks(boilerID.toString(), engineID.toString()))).carbon(1.0f))).sulfur(0.1f));
    }

    public static Emitter.Properties<?> blazeBurner() {
        return (Emitter.Properties)((Object)((Emitter.Properties)((Object)((SourceBase.Properties)((Object)Emitter.Properties.tile("burnTimeRemaining").enumIdAsRelatedBlocks())).carbon(1.0f))).sulfur(0.1f));
    }

    public static Emitter.Properties<?> fuelBurner() {
        return Emitter.Properties.fuel("BurnTime");
    }

    public static Emitter.Properties<?> crushingWheel() {
        return (Emitter.Properties)((Object)((SourceBase.Properties)((Object)Emitter.Properties.tile("Inventory/ProcessingTime").customFactory(CrushingWheel::new))).dust(4.0f));
    }

    public static Emitter.Properties<?> millstone() {
        return (Emitter.Properties)((Object)((SourceBase.Properties)((Object)Emitter.Properties.tile("Timer").customFactory(Millstone::new))).dust(1.0f));
    }

    static {
        INSTANCE = AbstractForgeMod.singletonInstance((String)MOD_ID, Create.class);
    }

    public static abstract class AbstractCrusher
    extends Emitter {
        public AbstractCrusher(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
        }

        protected abstract CompoundTag getInventoryTag(CompoundTag var1);

        @Override
        public boolean isActive(INBTSerializable<CompoundTag> nbtSource) {
            if (nbtSource != null && super.isActive(nbtSource)) {
                CompoundTag compound = TagHelper.serialize(nbtSource);
                float speed = compound.m_128457_("Speed");
                if (speed == 0.0f) {
                    return false;
                }
                CompoundTag inventoryTag = this.getInventoryTag(compound);
                int itemsCount = inventoryTag != null ? inventoryTag.m_128437_("Items", 10).size() : 0;
                return itemsCount > 0;
            }
            return false;
        }
    }

    public static class CrushingWheel
    extends AbstractCrusher {
        public CrushingWheel(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
        }

        @Override
        protected CompoundTag getInventoryTag(CompoundTag compound) {
            return TagHelper.getNestedCompound((CompoundTag)compound, (String)"Inventory");
        }
    }

    public static class Millstone
    extends AbstractCrusher {
        public Millstone(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
        }

        @Override
        protected CompoundTag getInventoryTag(CompoundTag compound) {
            return TagHelper.getNestedCompound((CompoundTag)compound, (String)"InputInventory");
        }
    }

    public static class Boiler
    extends Emitter {
        public Boiler(@Nullable UnitConfig config, Emitter.Properties<?> props) {
            super(config, (Emitter.Properties<?>)((Object)props.activeTag("#hardcoded_heat_check")));
        }

        @Override
        public boolean isActive(@Nullable INBTSerializable<CompoundTag> nbtSource) {
            if (nbtSource == null) {
                return false;
            }
            try {
                CompoundTag boiler = TagHelper.serialize(nbtSource).m_128469_("Boiler");
                boolean hasSupply = boiler.m_128457_("Supply") >= 10.0f;
                return hasSupply && (boiler.m_128471_("PassiveHeat") || boiler.m_128451_("ActiveHeat") > 0);
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

