/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.minecraft.forge.ForgeEndertech;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import java.lang.reflect.Method;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.ModList;

public class ImmersiveEngineering {

    public static class Crusher
    extends Emitter {
        private Class<?> crusherClass = null;
        private Method shouldRenderAsActive = null;

        public Crusher(UnitConfig config, Emitter.Properties<?> props) {
            super(config, (Emitter.Properties<?>)((Object)props.activeStateHardcoded()));
            if (ModList.get().isLoaded("immersiveengineering")) {
                try {
                    this.crusherClass = Class.forName("blusunrize.immersiveengineering.common.blocks.metal.CrusherBlockEntity");
                    this.shouldRenderAsActive = this.crusherClass.getMethod("shouldRenderAsActiveImpl", new Class[0]);
                }
                catch (Exception e) {
                    ForgeEndertech.getInstance().getLogger().error(e.toString());
                }
            }
        }

        @Override
        public boolean isActive(INBTSerializable<CompoundTag> nbtSource) {
            if (this.crusherClass != null && this.shouldRenderAsActive != null && this.crusherClass.isInstance(nbtSource)) {
                try {
                    return (Boolean)this.shouldRenderAsActive.invoke(nbtSource, new Object[0]);
                }
                catch (Exception e) {
                    return false;
                }
            }
            return false;
        }
    }
}

