/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.network.ForgeNetMsg;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class ImmersivePetroleum {

    public static class FuelConsumedMsg
    extends ForgeNetMsg<FuelConsumedMsg> {
        public int entityId = 0;
        public String fuelName = "";
        public int consumed = 0;

        public FuelConsumedMsg() {
        }

        public FuelConsumedMsg(Entity entity, FluidStack fuel, int consumed) {
            this.entityId = entity.m_19879_();
            this.fuelName = ForgeBlock.getRegistryName((Fluid)fuel.getFluid()).toString();
            this.consumed = consumed;
        }

        public FuelConsumedMsg create() {
            return new FuelConsumedMsg();
        }

        public void sendToServer() {
            AdPother.getInstance().getConnection().sendToServer((Object)this);
        }

        public void handle(Level level, Player player) {
            if (level.m_5776_()) {
                return;
            }
            Entity entity = level.m_6815_(this.entityId);
            if (entity == null) {
                return;
            }
            ResourceLocation fuelId = ResourceLocation.m_135820_((String)this.fuelName);
            if (fuelId == null) {
                return;
            }
            Fluid fuel = (Fluid)ForgeRegistries.FLUIDS.getValue(fuelId);
            if (fuel == null) {
                return;
            }
            WorldEvents.onFuelBurned(fuel, this.consumed, entity, WorldEvents.Alignment.BACK);
        }
    }

    public static class Motorboat {
        public static final void onFuelBurned(Entity boat, FluidStack fuelNow, FluidStack fuelBefore) {
            int consumed = fuelBefore.getAmount() - fuelNow.getAmount();
            if (consumed <= 0) {
                return;
            }
            if (boat.m_9236_().m_5776_()) {
                new FuelConsumedMsg(boat, fuelNow, consumed).sendToServer();
            }
        }
    }
}

