/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.compat;

import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.blocks.IEmitter;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.data.TagHelper;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.events.WorldEvents;
import com.endertech.minecraft.mods.adpother.sources.AbstractEntity;
import com.endertech.minecraft.mods.adpother.sources.AbstractRocket;
import com.endertech.minecraft.mods.adpother.sources.Emitter;
import com.endertech.minecraft.mods.adpother.sources.SourceBase;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.util.INBTSerializable;

public class Minecraft {
    public static Emitter.Properties<?> furnace() {
        return Emitter.Properties.fuel("BurnTime");
    }

    public static Emitter.Properties<?> fire() {
        return Emitter.Properties.block().customFactory(Fire::new);
    }

    public static Emitter.Properties<?> firework() {
        return (Emitter.Properties)((Object)((Emitter.Properties)((Object)((SourceBase.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.with(IEmitter.Type.ENTITY).activeTag("HasBeenShot"))).customFactory(Firework::new))).carbon(0.5f))).sulfur(0.1f));
    }

    public static Emitter.Properties<?> campfire(String id, boolean signal) {
        return ((Emitter.Properties)Emitter.Properties.block().id(id)).metadata("[lit=true, signal_fire=" + (signal ? "true" : "false") + "]").customFactory(Campfire::new);
    }

    public static Emitter.Properties<?> minecart() {
        return (Emitter.Properties)((Object)((Emitter.Properties)((Object)Emitter.Properties.entity("Fuel", WorldEvents.Alignment.TOP).carbon(1.0f))).sulfur(0.1f));
    }

    public static final void handleFireworkExplosion(FireworkRocketEntity entity) {
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            Emitter emitter;
            ServerLevel level2 = (ServerLevel)level;
            int explosionsTotal = 0;
            try {
                ItemStack itemstack = ItemStack.m_41712_((CompoundTag)TagHelper.serialize((INBTSerializable)entity).m_128469_("FireworksItem"));
                if (!itemstack.m_41619_()) {
                    explosionsTotal = Optional.ofNullable(itemstack.m_41737_("Fireworks")).map(tag -> tag.m_128437_("Explosions", 10)).map(ListTag::size).orElse(0);
                }
            }
            catch (Exception itemstack) {
                // empty catch block
            }
            if (explosionsTotal > 0 && (emitter = (Emitter)AdPother.getInstance().emitters.get((Entity)entity).orElse(null)) instanceof Firework) {
                Firework firework = (Firework)emitter;
                AbstractRocket.findEmitPositions((Level)level2, entity.m_20183_(), 5, explosionsTotal).forEach(pos -> firework.emitAt((Level)level2, (BlockPos)pos, firework.explosionEmissionsMultiplier));
            }
        }
    }

    public static final void handleItemEntityDamage(ItemEntity entity, DamageSource source) {
        if (source.m_269533_(DamageTypeTags.f_268745_) || source.m_276093_(DamageTypes.f_268482_)) {
            Level level = entity.m_9236_();
            BlockPos pos = entity.m_20183_();
            ItemStack stack = entity.m_32055_();
            if (stack.m_41720_() == Items.f_42448_) {
                return;
            }
            if (level.m_6425_(pos).m_205070_(FluidTags.f_13132_)) {
                pos = pos.m_7494_();
            }
            WorldEvents.onItemBurned(stack, level, pos);
        }
    }

    public static class Firework
    extends AbstractEntity {
        public final float explosionEmissionsMultiplier;

        public Firework(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
            this.explosionEmissionsMultiplier = config.getFloat(this.getClassCategory(), "explosionEmissionsMultiplier", 2.0f, FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(16.0f)), "Multiplier for the emissions from each explosion");
        }

        @Override
        public WorldEvents.Alignment getEmissionsAlignment() {
            return WorldEvents.Alignment.BOTTOM;
        }
    }

    public static class Campfire
    extends Emitter {
        public static ForgeConfigSpec.ConfigValue<Double> rate;

        public Campfire(UnitConfig config, Emitter.Properties<?> props) {
            super(config, props);
        }

        @Override
        public void emitAt(Level level, BlockPos pos, float factor) {
            super.emitAt(level, pos, factor * ((Double)rate.get()).floatValue());
        }
    }

    public static class Fire
    extends Emitter {
        private final boolean infiniteSourceOnly;

        public Fire(UnitConfig config, Emitter.Properties<?> props) {
            super(config, (Emitter.Properties<?>)((Object)props.activeStateHardcoded()));
            this.infiniteSourceOnly = UnitConfig.getBool((UnitConfig)config, (String)this.getClassCategory(), (String)"infiniteSourceOnly", (boolean)false, (String)"Produce emissions only from a burning infinite source such as netherrack, magma block, etc.");
            this.saveConfig();
        }

        public boolean infiniteSourceOnly() {
            return this.infiniteSourceOnly;
        }

        public boolean isActive(LevelReader level, BlockPos pos) {
            BlockPos sourcePos;
            BlockState state;
            Block block;
            boolean infiniteSource;
            if (this.infiniteSourceOnly() && !(infiniteSource = (block = (state = level.m_8055_(sourcePos = pos.m_7495_())).m_60734_()).isFireSource(state, level, sourcePos, Direction.UP))) {
                return false;
            }
            return super.isActive(level, pos);
        }
    }
}

