/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.init;

import com.endertech.minecraft.forge.blocks.ForgeBlock;
import com.endertech.minecraft.forge.configs.UnitConfig;
import com.endertech.minecraft.forge.core.AbstractForgeMod;
import com.endertech.minecraft.forge.items.EquipmentItem;
import com.endertech.minecraft.forge.items.ForgeBucketItem;
import com.endertech.minecraft.forge.items.GlassMeter;
import com.endertech.minecraft.forge.units.ItemsInit;
import com.endertech.minecraft.forge.units.UnitId;
import com.endertech.minecraft.mods.adpother.AdPother;
import com.endertech.minecraft.mods.adpother.blocks.AbstractGas;
import com.endertech.minecraft.mods.adpother.blocks.Dust;
import com.endertech.minecraft.mods.adpother.blocks.FilterFrame;
import com.endertech.minecraft.mods.adpother.init.Materials;
import com.endertech.minecraft.mods.adpother.items.Aerometer;
import com.endertech.minecraft.mods.adpother.items.GasBlockItem;
import com.endertech.minecraft.mods.adpother.items.Respirator;
import com.endertech.minecraft.mods.adpother.items.VacuumBag;
import com.endertech.minecraft.mods.adpother.items.VacuumTube;
import net.minecraft.ChatFormatting;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryObject;

public class Items
extends ItemsInit {
    public final RegistryObject<Aerometer> aerometer = this.register("aerometer", name -> new Aerometer(this.createConfig((String)name), ((GlassMeter.Properties)((GlassMeter.Properties)GlassMeter.Properties.of((String)name).durability(4)).equipmentSlot(EquipmentSlot.OFFHAND)).nameColor(ChatFormatting.GREEN)));
    public final RegistryObject<ForgeBucketItem> pollutedWaterBucket;

    public Items(AbstractForgeMod mod) {
        super(mod);
        UnitConfig bagConfig = this.createConfig("vacuum_bag");
        UnitConfig tubeConfig = this.createConfig("vacuum_tube");
        UnitConfig respiratorConfig = this.createConfig("respirator");
        for (Materials material : Materials.values()) {
            material.vacuumBag = this.register(material.getName() + "_vacuum_bag", name -> new VacuumBag(bagConfig, (VacuumBag.Properties)((VacuumBag.Properties)((VacuumBag.Properties)((VacuumBag.Properties)VacuumBag.Properties.of(name).capacity(material.capacity).durability(64)).repairMaterial(UnitId.from((String)"#forge:leather"))).equipmentSlot(EquipmentSlot.CHEST)).equipSound(SoundEvents.f_11678_)));
            material.vacuumTube = this.register(material.getName() + "_vacuum_tube", name -> new VacuumTube(tubeConfig, (VacuumTube.Properties)((VacuumTube.Properties)VacuumTube.Properties.of(name).speed(material.speed).durability(material.durability)).repairMaterial(UnitId.from((String)("#" + material.crafting.f_203868_())))));
            material.respirator = this.register(material.getName() + "_respirator", name -> new Respirator(respiratorConfig, ((EquipmentItem.Properties)((EquipmentItem.Properties)EquipmentItem.Properties.of((String)name).durability(material.durability)).repairMaterial(UnitId.from((String)"#forge:leather"))).equipmentSlot(EquipmentSlot.HEAD).equipSound(SoundEvents.f_12320_)));
            material.filterFrameItem = this.register(material.filterFrame, (name, block) -> new FilterFrame.BlockItem((ForgeBlock)block, new Item.Properties()));
        }
        this.pollutedWaterBucket = this.register("polluted_water_bucket", name -> new ForgeBucketItem(name, () -> (Fluid)AdPother.getInstance().fluids.pollutedWaterStill.get()));
    }

    protected void onRegistration(RegisterEvent event) {
        AdPother.getInstance().pollutants.mapAll().forEach((name, pollutant) -> {
            Object patt3677$temp = pollutant.get();
            if (patt3677$temp instanceof AbstractGas) {
                AbstractGas gas = (AbstractGas)((Object)((Object)patt3677$temp));
                Item.Properties props = new Item.Properties().setNoRepair();
                if (!(gas instanceof Dust)) {
                    props.m_41486_();
                }
                Lazy item = this.addUnit((String)name, () -> new GasBlockItem(gas, props));
                event.register(this.registryKey, helper -> helper.register(name, (Object)((Item)item.get())));
            }
        });
    }
}

