/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.mods.adpother.renderers;

import com.endertech.common.CommonMath;
import com.endertech.common.FloatBounds;
import com.endertech.minecraft.forge.client.renderer.GlassMeterRenderer;
import com.endertech.minecraft.forge.configs.ColorARGB;
import com.endertech.minecraft.forge.items.ForgeItem;
import com.endertech.minecraft.mods.adpother.blocks.Pollutant;
import com.endertech.minecraft.mods.adpother.items.Aerometer;
import com.endertech.minecraft.mods.adpother.pollution.EntityPollution;
import com.endertech.minecraft.mods.adpother.pollution.WorldData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

@OnlyIn(value=Dist.CLIENT)
public class AerometerRenderer
extends GlassMeterRenderer {
    static final ColorARGB COLOR_RED = ColorARGB.from((Color)Color.RED);

    public AerometerRenderer(BlockEntityRenderDispatcher dispatcher, EntityModelSet modelSet) {
        super(dispatcher, modelSet);
    }

    protected void renderIndicators(ItemStack stack, PoseStack matrix, MultiBufferSource buffer) {
        if (ForgeItem.isBroken((ItemStack)stack)) {
            return;
        }
        Optional<Entity> carrier = Aerometer.getCarrierFor(stack);
        if (carrier.isEmpty()) {
            return;
        }
        EntityPollution pollution = WorldData.getEntityPollution(carrier.get());
        VertexConsumer builder = buffer.m_6299_(this.getRenderType());
        double needleOffset = 0.001;
        double offset = 0.001;
        matrix.m_85836_();
        matrix.m_252880_(0.5f, 0.5f, 0.5f);
        matrix.m_252880_(0.0f, 0.0f, -0.04f);
        matrix.m_85837_(0.0, 0.0, offset);
        for (Pollutant<?> pollutant : pollution.getPollutants().toList()) {
            float factor = pollution.getInfluenceOf(pollutant).toFraction();
            ColorARGB color = pollutant.getColor();
            matrix.m_85837_(0.0, 0.0, offset);
            this.renderNeedle(builder, matrix, color, factor);
            matrix.m_85837_(0.0, 0.0, -offset);
            offset += 0.001;
        }
        if (pollution.hasExplosionRisk()) {
            this.renderExplosionRiskIndicator(builder, matrix, COLOR_RED);
        }
        matrix.m_85849_();
    }

    protected void renderExplosionRiskIndicator(VertexConsumer builder, PoseStack matrix, ColorARGB color) {
        float size = 0.3f;
        AerometerRenderer.addVertex((VertexConsumer)builder, (PoseStack)matrix, (ColorARGB)color, (float)0.0f, (float)0.3f, (float)0.5f, (float)0.0f);
        AerometerRenderer.addVertex((VertexConsumer)builder, (PoseStack)matrix, (ColorARGB)color, (float)-0.3f, (float)0.15f, (float)0.0f, (float)1.0f);
        AerometerRenderer.addVertex((VertexConsumer)builder, (PoseStack)matrix, (ColorARGB)color, (float)0.3f, (float)0.15f, (float)1.0f, (float)1.0f);
        AerometerRenderer.addVertex((VertexConsumer)builder, (PoseStack)matrix, (ColorARGB)color, (float)0.3f, (float)0.15f, (float)1.0f, (float)1.0f);
    }

    protected void renderNeedle(VertexConsumer builder, PoseStack matrix, ColorARGB color, float factor) {
        CommonMath.Angle angle = CommonMath.Angle.fromDegrees((double)(FloatBounds.between((Float)Float.valueOf(0.0f), (Float)Float.valueOf(180.0f)).interpolateDown(factor).floatValue() - 90.0f));
        matrix.m_85836_();
        matrix.m_252781_(new Quaternionf().rotateZ((float)angle.getRadians()));
        float sW = 0.05f;
        float sL = 0.35f;
        AerometerRenderer.addVertex((VertexConsumer)builder, (PoseStack)matrix, (ColorARGB)color, (float)-0.05f, (float)-0.07f, (float)0.0f, (float)0.0f);
        AerometerRenderer.addVertex((VertexConsumer)builder, (PoseStack)matrix, (ColorARGB)color, (float)0.05f, (float)-0.07f, (float)1.0f, (float)0.0f);
        AerometerRenderer.addVertex((VertexConsumer)builder, (PoseStack)matrix, (ColorARGB)color, (float)0.05f, (float)0.35f, (float)1.0f, (float)1.0f);
        AerometerRenderer.addVertex((VertexConsumer)builder, (PoseStack)matrix, (ColorARGB)color, (float)-0.05f, (float)0.35f, (float)0.0f, (float)1.0f);
        matrix.m_85849_();
    }
}

