/*
 * Decompiled with CFR 0.152.
 */
package com.endertech.minecraft.forge.world;

import com.endertech.common.IBounds;
import com.endertech.common.IntBounds;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.phys.AABB;

public class WorldBounds {
    private final IntBounds x;
    private final IntBounds y;
    private final IntBounds z;

    public static WorldBounds from(IntBounds x, IntBounds y, IntBounds z) {
        return new WorldBounds(x, y, z);
    }

    public static WorldBounds from(BlockPos pos, int radius) {
        return WorldBounds.from(IntBounds.of(pos.m_123341_()), IntBounds.of(pos.m_123342_()), IntBounds.of(pos.m_123343_())).extend(radius);
    }

    public static WorldBounds from(BlockPos pos1, BlockPos pos2) {
        return WorldBounds.from(IntBounds.between(pos1.m_123341_(), pos2.m_123341_()), IntBounds.between(pos1.m_123342_(), pos2.m_123342_()), IntBounds.between(pos1.m_123343_(), pos2.m_123343_()));
    }

    public static WorldBounds chunksAround(LevelHeightAccessor level, ChunkPos center) {
        ChunkPos min = new ChunkPos(center.f_45578_ - 1, center.f_45579_ - 1);
        ChunkPos max = new ChunkPos(center.f_45578_ + 1, center.f_45579_ + 1);
        return WorldBounds.from(IntBounds.between(min.m_45604_(), max.m_45608_()), WorldBounds.getHeightBounds(level), IntBounds.between(min.m_45605_(), max.m_45609_()));
    }

    public static IntBounds getHeightBounds(LevelHeightAccessor level) {
        return IntBounds.between(level.m_141937_(), level.m_151558_() - 1);
    }

    public static WorldBounds vertPlane(BlockPos centerPos, int radius, Direction normal) {
        if (normal.m_122434_().m_122478_()) {
            return WorldBounds.from(centerPos, centerPos);
        }
        Direction facing = normal.m_122427_();
        BlockPos from = new BlockPos((Vec3i)centerPos.m_5484_(facing, -radius).m_6625_(radius));
        BlockPos to = new BlockPos((Vec3i)centerPos.m_5484_(facing, radius).m_6630_(radius));
        WorldBounds bounds = WorldBounds.from(from, to);
        return bounds;
    }

    public static WorldBounds horizPlane(BlockPos center, int radius) {
        return WorldBounds.from(center.m_7918_(-radius, 0, -radius), center.m_7918_(radius, 0, radius));
    }

    protected WorldBounds(IntBounds x, IntBounds y, IntBounds z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public IntBounds getX() {
        return this.x;
    }

    public IntBounds getZ() {
        return this.z;
    }

    public IntBounds getY() {
        return this.y;
    }

    public int getHeight() {
        return this.getY().length() + 1;
    }

    public boolean encloses(BlockPos pos) {
        return this.getX().encloses(pos.m_123341_()) && this.getY().encloses(pos.m_123342_()) && this.getZ().encloses(pos.m_123343_());
    }

    public boolean within(WorldBounds bounds) {
        return this.getX().within(bounds.getX()) && this.getY().within(bounds.getY()) && this.getZ().within(bounds.getZ());
    }

    public WorldBounds offset(int x, int y, int z) {
        return WorldBounds.from(this.getX().offset(x), this.getY().offset(y), this.getZ().offset(z));
    }

    public WorldBounds extend(int x, int y, int z) {
        return WorldBounds.from(this.getX().extend(x), this.getY().extend(y), this.getZ().extend(z));
    }

    public WorldBounds extend(int value) {
        return this.extend(value, value, value);
    }

    public WorldBounds extend(Direction facing, int value) {
        IBounds x = this.getX().offset(facing.m_122429_() * value).unite((IBounds)this.getX());
        IBounds y = this.getY().offset(facing.m_122430_() * value).unite((IBounds)this.getY());
        IBounds z = this.getZ().offset(facing.m_122431_() * value).unite((IBounds)this.getZ());
        return WorldBounds.from((IntBounds)x, (IntBounds)y, (IntBounds)z);
    }

    public WorldBounds reduce(int x, int y, int z) {
        return WorldBounds.from(this.getX().reduce(x), this.getY().reduce(y), this.getZ().reduce(z));
    }

    public WorldBounds reduce(int value) {
        return this.reduce(value, value, value);
    }

    public BlockPos relative(BlockPos pos) {
        BlockPos min = this.min();
        return new BlockPos(pos.m_123341_() - min.m_123341_(), pos.m_123342_() - min.m_123342_(), pos.m_123343_() - min.m_123343_());
    }

    public boolean face(BlockPos pos) {
        return this.getX().corners(pos.m_123341_()) || this.getY().corners(pos.m_123342_()) || this.getZ().corners(pos.m_123343_());
    }

    public boolean edge(BlockPos pos) {
        int result = 0;
        if (this.getX().corners(pos.m_123341_())) {
            ++result;
        }
        if (this.getY().corners(pos.m_123342_())) {
            ++result;
        }
        if (this.getZ().corners(pos.m_123343_())) {
            ++result;
        }
        return result >= 2;
    }

    public boolean vertex(BlockPos pos) {
        return this.getX().corners(pos.m_123341_()) && this.getY().corners(pos.m_123342_()) && this.getZ().corners(pos.m_123343_());
    }

    public void forEach(Consumer<? super BlockPos.MutableBlockPos> action) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (int x : this.getX()) {
            for (int y : this.getY()) {
                for (int z : this.getZ()) {
                    pos.m_122178_(x, y, z);
                    action.accept((BlockPos.MutableBlockPos)pos);
                }
            }
        }
    }

    public BlockPos min() {
        return new BlockPos(this.getX().getMin().intValue(), this.getY().getMin().intValue(), this.getZ().getMin().intValue());
    }

    public BlockPos max() {
        return new BlockPos(this.getX().getMax().intValue(), this.getY().getMax().intValue(), this.getZ().getMax().intValue());
    }

    public BlockPos randomPos(Random random) {
        return new BlockPos(this.getX().randomBetween(random).intValue(), this.getY().randomBetween(random).intValue(), this.getZ().randomBetween(random).intValue());
    }

    public AABB toAABB() {
        return new AABB(this.min(), this.max());
    }
}

