function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'com/drmangotea/tfmg/blocks/machines/metal_processing/coke_oven/CokeOvenBlockEntity',
		'methodName' : 'setTimer',
		'methodDesc' : '()V'
	}

	var node = {
		'class' : 'com/simibubi/create/foundation/item/SmartInventory',
		'methodName' : resolveName('m_6836_'), // setItem
		'methodDesc' : '(ILnet/minecraft/world/item/ItemStack;)V'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFurnaceFuelBurned',
		'methodDesc' : '(Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [
	    insnDup("fuel stack"),
		insnPushValue(1, "fuel amount"),
		insnLoadThis("coke oven tile"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBefore(method, node, instructions);
				return method;
			}
		}
	}
}