function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile('coremods/core_functions.js')

	var target = {
		'type' : 'METHOD',
		'class' : 'net/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity',
		'methodName' : resolveName('m_155013_'), // serverTick
		'methodDesc' : '(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;Lnet/minecraft/world/level/block/entity/AbstractFurnaceBlockEntity;)V'
	}

	var node = {
		'class' : 'net/minecraft/world/item/ItemStack',
		'methodName' : 'hasCraftingRemainingItem',
		'methodDesc' : '()Z'
	}
	
	var handler = {
		'class' : 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName' : 'onFurnaceFuelBurned',
		'methodDesc' : '(Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/world/level/block/entity/BlockEntity;)V'
	}

	var instructions = [
	    insnDup("fuel stack"),
		insnPushValue(1, "fuel amount"),
		insnLoadObj(3, "furnace tile"),
		insnCallHandler(handler)
	];

	return {
		'coremod' : {
			'target' : target,
			'transformer' : function(method) {
				insertInstructionsBefore(method, node, instructions);
				return method;
			}
		}
	}
}