function initializeCoreMod() {
	Java.type('net.minecraftforge.coremod.api.ASMAPI').loadFile(
		'coremods/core_functions.js')

	var target = {
		'type': 'METHOD',
		'class': 'xyz/przemyk/simpleplanes/upgrades/engines/furnace/FurnaceEngineUpgrade',
		'methodName': 'tick',
		'methodDesc': '()V'
	}

	var node = {
		'class': 'net/minecraft/world/item/ItemStack',
		'methodName': 'hasCraftingRemainingItem',
		'methodDesc': '()Z'
	}

	var handler = {
		'class': 'com/endertech/minecraft/mods/adpother/events/WorldEvents',
		'methodName': 'onFuelBurned',
		'methodDesc': '(Lnet/minecraft/world/item/ItemStack;ILnet/minecraft/world/entity/Entity;Lcom/endertech/minecraft/mods/adpother/events/WorldEvents$Alignment;)V'
	}

	var planeEntity = {
		'class': 'xyz/przemyk/simpleplanes/upgrades/engines/furnace/FurnaceEngineUpgrade',
		'fieldName': 'planeEntity',
		'fieldDesc': 'Lxyz/przemyk/simpleplanes/entities/PlaneEntity;'
	}

	var alignment = {
		'class': 'com/endertech/minecraft/mods/adpother/events/WorldEvents$Alignment',
		'fieldName': 'CENTER',
		'fieldDesc': 'Lcom/endertech/minecraft/mods/adpother/events/WorldEvents$Alignment;'
	}

	var instructions = [
		insnDup("fuel itemstack"),
		insnPushValue(1, "fuel amount"),
		insnLoadThis("furnace engine upgrade"),
		insnGetField(planeEntity),
		insnGetStatic(alignment),
		insnCallHandler(handler)
	];

	return {
		'coremod': {
			'target': target,
			'transformer': function(method) {
				insertInstructionsBefore(method, node, instructions);
				return method;
			}
		}
	}
}