/*
 * Decompiled with CFR 0.152.
 */
package net.dyrohc.cravings;

import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ConfigFileServer {
    public static final ForgeConfigSpec SERVER_CONFIG;
    public static ForgeConfigSpec.BooleanValue CFG_sweet_craving_toggle;
    public static ForgeConfigSpec.BooleanValue CFG_healthy_craving_toggle;
    public static ForgeConfigSpec.BooleanValue CFG_meaty_craving_toggle;
    public static ForgeConfigSpec.BooleanValue CFG_fishy_craving_toggle;
    public static ForgeConfigSpec.BooleanValue CFG_gross_craving_toggle;
    public static ForgeConfigSpec.BooleanValue CFG_fancy_craving_toggle;
    public static ForgeConfigSpec.BooleanValue CFG_hearty_craving_toggle;
    public static ForgeConfigSpec.BooleanValue CFG_raw_craving_toggle;
    public static ForgeConfigSpec.IntValue CFG_craving_set_interval;
    public static ForgeConfigSpec.BooleanValue CFG_particles_toggle;
    public static ForgeConfigSpec.IntValue CFG_sweet_craving_weight;
    public static ForgeConfigSpec.IntValue CFG_healthy_craving_weight;
    public static ForgeConfigSpec.IntValue CFG_meaty_craving_weight;
    public static ForgeConfigSpec.IntValue CFG_fishy_craving_weight;
    public static ForgeConfigSpec.IntValue CFG_gross_craving_weight;
    public static ForgeConfigSpec.IntValue CFG_fancy_craving_weight;
    public static ForgeConfigSpec.IntValue CFG_hearty_craving_weight;
    public static ForgeConfigSpec.IntValue CFG_raw_craving_weight;
    public static ForgeConfigSpec.IntValue CFG_sweet_xp_amount;
    public static ForgeConfigSpec.DoubleValue CFG_sweet_saturation_amount;
    public static ForgeConfigSpec.IntValue CFG_sweet_speed_level;
    public static ForgeConfigSpec.IntValue CFG_sweet_speed_duration;
    public static ForgeConfigSpec.IntValue CFG_healthy_xp_amount;
    public static ForgeConfigSpec.DoubleValue CFG_healthy_saturation_amount;
    public static ForgeConfigSpec.IntValue CFG_healthy_haste_level;
    public static ForgeConfigSpec.IntValue CFG_healthy_haste_duration;
    public static ForgeConfigSpec.IntValue CFG_meaty_xp_amount;
    public static ForgeConfigSpec.DoubleValue CFG_meaty_saturation_amount;
    public static ForgeConfigSpec.IntValue CFG_meaty_strength_level;
    public static ForgeConfigSpec.IntValue CFG_meaty_strength_duration;
    public static ForgeConfigSpec.IntValue CFG_fishy_xp_amount;
    public static ForgeConfigSpec.DoubleValue CFG_fishy_saturation_amount;
    public static ForgeConfigSpec.IntValue CFG_fishy_wbreathing_duration;
    public static ForgeConfigSpec.IntValue CFG_gross_xp_amount;
    public static ForgeConfigSpec.DoubleValue CFG_gross_saturation_amount;
    public static ForgeConfigSpec.IntValue CFG_gross_resistance_level;
    public static ForgeConfigSpec.IntValue CFG_gross_resistance_duration;
    public static ForgeConfigSpec.IntValue CFG_fancy_xp_amount;
    public static ForgeConfigSpec.DoubleValue CFG_fancy_saturation_amount;
    public static ForgeConfigSpec.IntValue CFG_fancy_nvision_duration;
    public static ForgeConfigSpec.IntValue CFG_hearty_xp_amount;
    public static ForgeConfigSpec.DoubleValue CFG_hearty_saturation_amount;
    public static ForgeConfigSpec.IntValue CFG_hearty_hboost_level;
    public static ForgeConfigSpec.IntValue CFG_hearty_hboost_duration;
    public static ForgeConfigSpec.IntValue CFG_raw_xp_amount;
    public static ForgeConfigSpec.DoubleValue CFG_raw_saturation_amount;
    public static ForgeConfigSpec.IntValue CFG_raw_nausea_level;
    public static ForgeConfigSpec.IntValue CFG_raw_nausea_duration;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_sweet_foods;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_healthy_foods;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_meaty_foods;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_fishy_foods;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_gross_foods;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_fancy_foods;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_hearty_foods;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_raw_foods;
    public static ForgeConfigSpec.BooleanValue CFG_FD_toggle;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_FD_sweet_foods;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_FD_healthy_foods;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_FD_meaty_foods;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_FD_fishy_foods;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_FD_gross_foods;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_FD_fancy_foods;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_FD_hearty_foods;
    public static ForgeConfigSpec.ConfigValue<List<? extends String>> CFG_FD_raw_foods;

    static {
        ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
        BUILDER.comment("I recommend an app to make TOML files prettier, this looks messy when using notepad.").comment("Disable or enable the different cravings.").push("Craving Toggles");
        CFG_sweet_craving_toggle = BUILDER.comment("Toggle the chance to crave something sweet. (Default: true)").define("Sweet Craving Toggle", true);
        CFG_healthy_craving_toggle = BUILDER.comment("Toggle the chance to crave something healthy. (Default: true)").define("Healthy Craving Toggle", true);
        CFG_meaty_craving_toggle = BUILDER.comment("Toggle the chance to crave something meaty. (Default: true)").define("Meaty Craving Toggle", true);
        CFG_fishy_craving_toggle = BUILDER.comment("Toggle the chance to crave something fishy. (Default: true)").define("Fishy Craving Toggle", true);
        CFG_gross_craving_toggle = BUILDER.comment("Toggle the chance to crave something gross. (Default: true)").define("Gross Craving Toggle", true);
        CFG_fancy_craving_toggle = BUILDER.comment("Toggle the chance to crave something fancy. (Default: true)").define("Fancy Craving Toggle", true);
        CFG_hearty_craving_toggle = BUILDER.comment("Toggle the chance to crave something hearty. (Default: true)").define("Hearty Craving Toggle", true);
        CFG_raw_craving_toggle = BUILDER.comment("Toggle the chance to crave something raw. (Default: true)").define("Raw Craving Toggle", true);
        BUILDER.pop();
        BUILDER.comment("Miscellaneous settings about different aspects of the mod.").push("Miscellaneous Settings");
        CFG_craving_set_interval = BUILDER.comment("How long will it take to crave something different. (Default: 12000)").comment("If you change this, make sure to tweak the effect's durations below to keep it balanced.").comment("Changing the effects to last half of this is a good starting point.").defineInRange("Time Between Cravings", 12000, 1, Integer.MAX_VALUE);
        CFG_particles_toggle = BUILDER.comment("Enable potion effect particles for benefits gained by satisfying cravings. (default: false)").comment("If true, ambient particles will be used, which are less intrusive and less visible.").define("Toggle Effect Particles", false);
        BUILDER.pop();
        BUILDER.comment("Craving Weights. These determine the chances of each craving triggering compared to each other.").comment("Weights are used instead of straight up chances. The higher the weight in comparison with the others, the higher the chance.").comment("Example: If Sweet = 40 and Healthy = 20, then Sweet has double the chance of being picked than healthy.").push("Craving Weights");
        CFG_sweet_craving_weight = BUILDER.comment("Chance to crave something sweet. (Default: 20)").defineInRange("Sweet Craving Chance", 20, 1, 1000);
        CFG_healthy_craving_weight = BUILDER.comment("Chance to crave something healthy. (Default: 20)").defineInRange("Healthy Craving Chance", 20, 1, 1000);
        CFG_meaty_craving_weight = BUILDER.comment("Chance to crave something meaty. (Default: 20)").defineInRange("Meaty Craving Chance", 20, 1, 1000);
        CFG_fishy_craving_weight = BUILDER.comment("Chance to crave something fishy. (Default: 17)").defineInRange("Fishy Craving Chance", 17, 1, 1000);
        CFG_gross_craving_weight = BUILDER.comment("Chance to crave something gross. (Default: 17)").defineInRange("Gross Craving Chance", 17, 1, 1000);
        CFG_fancy_craving_weight = BUILDER.comment("Chance to crave something fancy. (Default: 14)").defineInRange("Fancy Craving Chance", 14, 1, 1000);
        CFG_hearty_craving_weight = BUILDER.comment("Chance to crave something hearty. (Default: 14)").defineInRange("Hearty Craving Chance", 14, 1, 1000);
        CFG_raw_craving_weight = BUILDER.comment("Chance to crave something raw. (Default: 5)").defineInRange("Raw Craving Chance", 5, 1, 1000);
        BUILDER.pop();
        BUILDER.comment("Sweet craving related settings.").push("Sweet Craving Settings");
        CFG_sweet_xp_amount = BUILDER.comment("XP points awarded when satisfying the sweet craving. (Default: 3)").defineInRange("Sweet XP Amount", 3, 0, Integer.MAX_VALUE);
        CFG_sweet_saturation_amount = BUILDER.comment("Extra saturation points gained when satisfying the sweet craving. (Default: 1)").defineInRange("Sweet Saturation Amount", 1.0, 0.0, 20.0);
        CFG_sweet_speed_level = BUILDER.comment("Speed effect level applied when satisfying the sweet craving. (Default: 1)").defineInRange("Sweet Speed Level", 1, 1, 255);
        CFG_sweet_speed_duration = BUILDER.comment("Duration (in ticks) of the speed effect when satisfying the sweet craving. (Default: 6000)").defineInRange("Sweet Speed Duration", 6000, 1, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.comment("Healthy craving related settings.").push("Healthy Craving Settings");
        CFG_healthy_xp_amount = BUILDER.comment("XP points awarded when satisfying the healthy craving. (Default: 3)").defineInRange("Healthy XP Amount", 3, 0, Integer.MAX_VALUE);
        CFG_healthy_saturation_amount = BUILDER.comment("Extra saturation points gained when satisfying the healthy craving. (Default: 1)").defineInRange("Healthy Saturation Amount", 1.0, 0.0, 20.0);
        CFG_healthy_haste_level = BUILDER.comment("Haste effect level applied when satisfying the healthy craving. (Default: 1)").defineInRange("Healthy Haste Level", 1, 1, 255);
        CFG_healthy_haste_duration = BUILDER.comment("Duration (in ticks) of the haste effect when satisfying the healthy craving. (Default: 6000)").defineInRange("Healthy Haste Duration", 6000, 1, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.comment("Meaty craving related settings.").push("Meaty Craving Settings");
        CFG_meaty_xp_amount = BUILDER.comment("XP points awarded when satisfying the meaty craving. (Default: 3)").defineInRange("Meaty XP Amount", 3, 0, Integer.MAX_VALUE);
        CFG_meaty_saturation_amount = BUILDER.comment("Extra saturation points gained when satisfying the meaty craving. (Default: 1)").defineInRange("Meaty Saturation Amount", 1.0, 0.0, 20.0);
        CFG_meaty_strength_level = BUILDER.comment("Strength effect level applied when satisfying the meaty craving. (Default: 1)").defineInRange("Meaty Strength Level", 1, 1, 255);
        CFG_meaty_strength_duration = BUILDER.comment("Duration (in ticks) of the strength effect when satisfying the meaty craving. (Default: 6000)").defineInRange("Meaty Strength Duration", 6000, 1, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.comment("Fishy craving related settings.").push("Fishy Craving Settings");
        CFG_fishy_xp_amount = BUILDER.comment("XP points awarded when satisfying the fishy craving. (Default: 5)").defineInRange("Fishy XP Amount", 5, 0, Integer.MAX_VALUE);
        CFG_fishy_saturation_amount = BUILDER.comment("Extra saturation points gained when satisfying the fishy craving. (Default: 1)").defineInRange("Fishy Saturation Amount", 1.0, 0.0, 20.0);
        CFG_fishy_wbreathing_duration = BUILDER.comment("Duration (in ticks) of the water breathing effect when satisfying the fishy craving. (Default: 6000)").defineInRange("Fishy Water Breathing Duration", 6000, 1, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.comment("Gross craving related settings.").push("Gross Craving Settings");
        CFG_gross_xp_amount = BUILDER.comment("XP points awarded when satisfying the gross craving. (Default: 5)").defineInRange("Gross XP Amount", 5, 0, Integer.MAX_VALUE);
        CFG_gross_saturation_amount = BUILDER.comment("Extra saturation points gained when satisfying the gross craving. (Default: 0.5)").defineInRange("Gross Saturation Amount", 0.5, 0.0, 20.0);
        CFG_gross_resistance_level = BUILDER.comment("Resistance effect level applied when satisfying the gross craving. (Default: 1)").defineInRange("Gross Resistance Level", 1, 1, 255);
        CFG_gross_resistance_duration = BUILDER.comment("Duration (in ticks) of the resistance effect when satisfying the gross craving. (Default: 6000)").defineInRange("Gross Resistance Duration", 6000, 1, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.comment("Fancy craving related settings.").push("Fancy Craving Settings");
        CFG_fancy_xp_amount = BUILDER.comment("XP points awarded when satisfying the Fancy craving. (Default: 8)").defineInRange("Fancy XP Amount", 8, 0, Integer.MAX_VALUE);
        CFG_fancy_saturation_amount = BUILDER.comment("Extra saturation points gained when satisfying the fancy craving. (Default: 1)").defineInRange("Fancy Saturation Amount", 1.0, 0.0, 20.0);
        CFG_fancy_nvision_duration = BUILDER.comment("Duration (in ticks) of the night vision effect when satisfying the fancy craving. (Default: 6000)").defineInRange("Fancy Night Vision Duration", 6000, 1, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.comment("Hearty craving related settings.").push("Hearty Craving Settings");
        CFG_hearty_xp_amount = BUILDER.comment("XP points awarded when satisfying the Hearty craving. (Default: 8)").defineInRange("Hearty XP Amount", 8, 0, Integer.MAX_VALUE);
        CFG_hearty_saturation_amount = BUILDER.comment("Extra saturation points gained when satisfying the Hearty craving. (Default: 1.5)").defineInRange("Hearty Saturation Amount", 1.5, 0.0, 20.0);
        CFG_hearty_hboost_level = BUILDER.comment("Health boost effect level applied when satisfying the hearty craving. (Default: 1)").defineInRange("Hearty Health Boost Level", 1, 1, 255);
        CFG_hearty_hboost_duration = BUILDER.comment("Duration (in ticks) of the health boost effect when satisfying the hearty craving. (Default: 6000)").defineInRange("Hearty Health Boost Duration", 6000, 1, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.comment("Raw craving related settings.").push("Raw Craving Settings");
        CFG_raw_xp_amount = BUILDER.comment("XP points awarded when satisfying the Raw craving. (Default: 10)").defineInRange("Raw XP Amount", 10, 0, Integer.MAX_VALUE);
        CFG_raw_saturation_amount = BUILDER.comment("Extra saturation points gained when satisfying the Raw craving. (Default: 0.5)").defineInRange("Raw Saturation Amount", 0.5, 0.0, 20.0);
        CFG_raw_nausea_level = BUILDER.comment("Nausea effect level applied when satisfying the raw craving. (Default: 10)").defineInRange("Raw Nausea Level", 10, 1, 255);
        CFG_raw_nausea_duration = BUILDER.comment("Duration (in ticks) of the nausea effect when satisfying the raw craving. (Default: 600)").defineInRange("Raw Nausea Duration", 600, 1, Integer.MAX_VALUE);
        BUILDER.pop();
        BUILDER.comment("Cravings Foods. Foods that will satisfy each craving. Modded foods go here too.").push("Cravings Foods");
        CFG_sweet_foods = BUILDER.comment("Food items that satisfy your sweet craving.").defineListAllowEmpty("Sweet Foods", List.of("minecraft:cookie", "minecraft:glow_berries", "minecraft:honey_bottle", "minecraft:sweet_berries", "minecraft:melon_slice", "minecraft:chorus_fruit", "minecraft:apple", "minecraft:golden_apple", "minecraft:enchanted_golden_apple", "minecraft:pumpkin_pie", "minecraft:cake"), obj -> obj instanceof String);
        CFG_healthy_foods = BUILDER.comment("Food items that satisfy your healthy craving.").defineListAllowEmpty("Healthy Foods", List.of("minecraft:potato", "minecraft:carrot", "minecraft:beetroot", "minecraft:beetroot_soup", "minecraft:baked_potato", "minecraft:golden_carrot", "minecraft:dried_kelp"), obj -> obj instanceof String);
        CFG_meaty_foods = BUILDER.comment("Food items that satisfy your meaty craving.").defineListAllowEmpty("Meaty Foods", List.of("minecraft:rabbit_stew", "minecraft:cooked_rabbit", "minecraft:cooked_chicken", "minecraft:cooked_beef", "minecraft:cooked_porkchop", "minecraft:cooked_mutton"), obj -> obj instanceof String);
        CFG_fishy_foods = BUILDER.comment("Food items that satisfy your fishy craving.").defineListAllowEmpty("Fishy Foods", List.of("minecraft:cooked_cod", "minecraft:cooked_salmon", "minecraft:pufferfish"), obj -> obj instanceof String);
        CFG_gross_foods = BUILDER.comment("Food items that satisfy your gross craving.").defineListAllowEmpty("Gross Foods", List.of("minecraft:rotten_flesh", "minecraft:spider_eye", "minecraft:suspicious_stew", "minecraft:poisonous_potato", "minecraft:pufferfish"), obj -> obj instanceof String);
        CFG_fancy_foods = BUILDER.comment("Food items that satisfy your fancy craving.").defineListAllowEmpty("Fancy Foods", List.of("minecraft:golden_apple", "minecraft:enchanted_golden_apple", "minecraft:golden_carrot", "minecraft:glow_berries"), obj -> obj instanceof String);
        CFG_hearty_foods = BUILDER.comment("Food items that satisfy your hearty craving.").defineListAllowEmpty("Hearty Foods", List.of("minecraft:pumpkin_pie", "minecraft:rabbit_stew", "minecraft:mushroom_stew", "minecraft:beetroot_soup"), obj -> obj instanceof String);
        CFG_raw_foods = BUILDER.comment("Food items that satisfy your raw craving.").defineListAllowEmpty("Raw Foods", List.of("minecraft:cod", "minecraft:salmon", "minecraft:rabbit", "minecraft:porkchop", "minecraft:mutton", "minecraft:chicken", "minecraft:beef"), obj -> obj instanceof String);
        BUILDER.pop();
        BUILDER.comment("Farmer's Delight compatibility options").push("Farmer's Delight Compat");
        CFG_FD_toggle = BUILDER.comment("Enable Farmer's Delight foods satisfying cravings out of the box. Will only work if Farmer's Delight is installed. (Default: true)").define("Farmer's Delight Compatibility", true);
        CFG_FD_sweet_foods = BUILDER.comment("Farmer's Delight food items that satisfy your sweet craving.").defineListAllowEmpty("Sweet Foods", List.of("farmersdelight:honey_glazed_ham", "farmersdelight:apple_pie", "farmersdelight:apple_pie_slice", "farmersdelight:sweet_berry_cheesecake", "farmersdelight:sweet_berry_cheesecake_slice", "farmersdelight:chocolate_pie", "farmersdelight:chocolate_pie_slice", "farmersdelight:cake_slice", "farmersdelight:honey_cookie", "farmersdelight:sweet_berry_cookie", "farmersdelight:glow_berry_custard", "farmersdelight:melon_popsicle", "farmersdelight:hot_cocoa", "farmersdelight:apple_cider", "farmersdelight:melon_juice", "farmersdelight:fruit_salad", "farmersdelight:tomato_sauce", "farmersdelight:pumpkin_slice"), obj -> obj instanceof String);
        CFG_FD_healthy_foods = BUILDER.comment("Farmer's Delight food items that satisfy your healthy craving.").defineListAllowEmpty("Healthy Foods", List.of("farmersdelight:cabbage", "farmersdelight:cabbage_leaf", "farmersdelight:onion", "farmersdelight:tomato", "farmersdelight:dumplings", "farmersdelight:cabbage_rolls", "farmersdelight:kelp_roll", "farmersdelight:kelp_roll_slice", "farmersdelight:mixed_salad", "farmersdelight:vegetable_soup", "farmersdelight:vegetable_noodles", "farmersdelight:ratatouille", "farmersdelight:cooked_rice", "farmersdelight:fried_egg", "farmersdelight:fried_rice"), obj -> obj instanceof String);
        CFG_FD_meaty_foods = BUILDER.comment("Farmer's Delight food items that satisfy your meaty craving.").defineListAllowEmpty("Meaty Foods", List.of("farmersdelight:barbecue_stick", "farmersdelight:chicken_sandwich", "farmersdelight:hamburger", "farmersdelight:bacon_sandwich", "farmersdelight:mutton_wrap", "farmersdelight:roast_chicken", "farmersdelight:honey_glazed_ham", "farmersdelight:shepherds_pie", "farmersdelight:beef_stew", "farmersdelight:chicken_soup", "farmersdelight:bacon_and_eggs", "farmersdelight:roasted_mutton_chops", "farmersdelight:steak_and_potatoes", "farmersdelight:beef_patty", "farmersdelight:cooked_chicken_cuts", "farmersdelight:cooked_bacon", "farmersdelight:cooked_mutton_chops", "farmersdelight:smoked_ham"), obj -> obj instanceof String);
        CFG_FD_fishy_foods = BUILDER.comment("Farmer's Delight food items that satisfy your fishy craving.").defineListAllowEmpty("Fishy Foods", List.of("farmersdelight:salmon_roll", "farmersdelight:cod_roll", "farmersdelight:fish_stew", "farmersdelight:baked_cod_stew", "farmersdelight:squid_ink_pasta", "farmersdelight:grilled_salmon", "farmersdelight:cooked_cod_slice", "farmersdelight:cooked_salmon_slice"), obj -> obj instanceof String);
        CFG_FD_gross_foods = BUILDER.comment("Farmer's Delight food items that satisfy your gross craving.").defineListAllowEmpty("Gross Foods", List.of("farmersdelight:dog_food", "farmersdelight:nether_salad", "farmersdelight:bone_broth"), obj -> obj instanceof String);
        CFG_FD_fancy_foods = BUILDER.comment("Farmer's Delight food items that satisfy your fancy craving.").defineListAllowEmpty("Fancy Foods", List.of("farmersdelight:glow_berry_custard"), obj -> obj instanceof String);
        CFG_FD_hearty_foods = BUILDER.comment("Farmer's Delight food items that satisfy your hearty craving.").defineListAllowEmpty("Hearty Foods", List.of("farmersdelight:stuffed_pumpkin", "farmersdelight:honey_glazed_ham", "farmersdelight:shepherds_pie", "farmersdelight:roast_chicken", "farmersdelight:beef_stew", "farmersdelight:chicken_soup", "farmersdelight:pumpkin_soup", "farmersdelight:baked_cod_stew", "farmersdelight:noodle_soup", "farmersdelight:bacon_and_eggs", "farmersdelight:pasta_with_meatballs", "farmersdelight:pasta_with_mutton_chop", "farmersdelight:mushroom_rice", "farmersdelight:roasted_mutton_chops", "farmersdelight:steak_and_potatoes", "farmersdelight:ratatouille", "farmersdelight:squid_ink_pasta", "farmersdelight:grilled_salmon", "farmersdelight:fried_rice", "farmersdelight:fish_stew"), obj -> obj instanceof String);
        CFG_FD_raw_foods = BUILDER.comment("Farmer's Delight food items that satisfy your raw craving.").defineListAllowEmpty("Raw Foods", List.of("farmersdelight:minced_beef", "farmersdelight:chicken_cuts", "farmersdelight:bacon", "farmersdelight:cod_slice", "farmersdelight:salmon_slice", "farmersdelight:mutton_chops", "farmersdelight:ham"), obj -> obj instanceof String);
        SERVER_CONFIG = BUILDER.build();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)SERVER_CONFIG, "Cravings.toml");
    }
}

