/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.minepiece;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;

public class CustomBiomeProvider
extends BiomeSource {
    public static final Codec<CustomBiomeProvider> CODEC = RecordCodecBuilder.create((T instance) -> instance.group((App)Codec.list((Codec)ResourceKey.m_195966_((ResourceKey)Registries.f_256952_)).fieldOf("biomes").forGetter(provider -> provider.biomeKeys)).apply((Applicative)instance, CustomBiomeProvider::create));
    private final List<ResourceKey<Biome>> biomeKeys;
    private Holder<Biome> redLineBiomeHolder;
    private Holder<Biome> defaultBiomeHolder;

    public CustomBiomeProvider(List<ResourceKey<Biome>> biomeKeys) {
        this.biomeKeys = biomeKeys;
    }

    public CustomBiomeProvider(ServerLevel serverLevel) {
        ResourceKey redLineKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("minepiece", "red_line_biome"));
        ResourceKey plainsKey = ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("minecraft", "plains"));
        this.biomeKeys = List.of(redLineKey, plainsKey);
        this.redLineBiomeHolder = serverLevel.m_9598_().m_175515_(Registries.f_256952_).m_246971_(redLineKey);
        this.defaultBiomeHolder = serverLevel.m_9598_().m_175515_(Registries.f_256952_).m_246971_(plainsKey);
    }

    public static CustomBiomeProvider create(List<ResourceKey<Biome>> biomeKeys) {
        return new CustomBiomeProvider(biomeKeys);
    }

    protected Codec<? extends BiomeSource> m_5820_() {
        return CODEC;
    }

    public Holder<Biome> m_203407_(int quartX, int quartY, int quartZ, Climate.Sampler sampler) {
        int x;
        if (this.redLineBiomeHolder == null || this.defaultBiomeHolder == null) {
            // empty if block
        }
        if ((x = quartX << 2) < 0 && x > -3000) {
            return this.redLineBiomeHolder;
        }
        return this.defaultBiomeHolder;
    }

    public Stream<Holder<Biome>> m_274359_() {
        if (this.redLineBiomeHolder != null && this.defaultBiomeHolder != null) {
            return Stream.of(this.redLineBiomeHolder, this.defaultBiomeHolder);
        }
        return this.biomeKeys.stream().map(key -> Holder.m_205709_(null));
    }
}

